
import { _decorator, Component, Node, systemEvent, SystemEventType, SystemEvent, macro, director, game, sys } from 'cc';
import { Util } from '../../module/util';
import prefabManager from '../manager/prefabManager';
const { ccclass, property } = _decorator;


export class GlobalEvent {
   private static isInit = false;
   private static preManager = window.PrefabManager;
   private static clickbackTime = 0; // 按下时间

   public static Init(){
       if(GlobalEvent.isInit){
           return;
       }
       GlobalEvent.isInit = true;
       Util.log('初始化全局事件...');
   }

   private static onBackPressed() {
        Util.log("-----onBackPressed----");
        if(GlobalEvent.clickbackTime + 1000 < (new Date()).getTime()) {
            GlobalEvent.clickbackTime = (new Date()).getTime();
            GlobalEvent.showMsg('再按一次退出应用.', 1);
        } else {
            Util.log("-----退出----");
            // cc.director.end();//该种方式关闭应用会一直报错。
            //
            director.pause();
            if(director.isPaused()) {
                game.end();
            }
        } 
    }
    // 显示提示框
    private static showMsg(txt:string,timer:number = 0){
        if(GlobalEvent.preManager)
            GlobalEvent.preManager.msg(txt,timer);
    }

}

declare global {
    interface Window {
        GlobalEvent: any
    }
  }
window.GlobalEvent = GlobalEvent;