
import { _decorator, Component, Node, loader, systemEvent } from 'cc';
const { ccclass, property } = _decorator;


export default class NetBase {
    private static timeOut:number=10000; // 超时时间,毫秒
    

    protected static GET(url:string, params:{[index:string]:string}|null=null, callback:Function|null=null, isShowError:boolean=false) {
        let dataStr = '';
        if(params){
            Object.keys(params).forEach(key => {
                dataStr += key + '=' + encodeURIComponent(params[key]) + '&';
            })
        }
        
        if (dataStr !== '') {
            dataStr = dataStr.substr(0, dataStr.lastIndexOf('&'));
            url = url + '?' + dataStr;
        }
        // url = HttpUtil.baseUrl + url;

        let xhr = new XMLHttpRequest();
        xhr.open("GET", url, true);
        xhr.setRequestHeader("Content-Type", "text/plain;charset=UTF-8");
        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4) {
                let response = xhr.responseText;
                if (xhr.status >= 200 && xhr.status < 300) {
                    let httpStatus = xhr.statusText;
                    // callback(true, JSON.parse(response));
                    if(callback){
                        callback(1, response);
                    }
                } else {
                    if(callback){
                        callback(0, response);
                    }
                }
                return;
            }
            if(isShowError)
                NetBase.showError(xhr.readyState, xhr.status);
        };
        xhr.ontimeout = function() {
            if(callback){
                callback(-1, '');
            }
            NetBase.showTimeOut();
        }
        xhr.timeout = this.timeOut;
        xhr.send();
    }

    protected static POST(url:string, param:{[index:string]:string}|null=null, callback:Function|null=null, isShowError:boolean=false) {
        let xhr = new XMLHttpRequest();
        let dataStr = '';
        if(param){
            Object.keys(param).forEach(key => {
                dataStr += key + '=' + encodeURIComponent(param[key]) + '&';
            })
        }
        if (dataStr !== '') {
            dataStr = dataStr.substr(0, dataStr.lastIndexOf('&'));
        }
        xhr.open("POST", url, true);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4) {
                let response = xhr.responseText;
                if (xhr.status >= 200 && xhr.status < 300) {
                    let httpStatus = xhr.statusText;
                    if(callback){
                        callback(true, response);
                        return;
                    }
                } else {
                    if(callback){
                        callback(false, response);
                        return;
                    } 
                }
            }
            if(isShowError)
                NetBase.showError(xhr.readyState, xhr.status);
        };
        xhr.timeout = this.timeOut;
        xhr.send(dataStr);
    }

    private static showError(readyState:number, status:number){
        systemEvent.emit("showMsg", '请求失败!state='+readyState+',status='+status);
    }
    private static showTimeOut(){
        systemEvent.emit("showMsg", '请求超时!请稍后重试!');
    }
}

