
import { _decorator, Component, Node, view, UITransform, UIOpacity, tween, Vec3 } from 'cc';
import { Util } from '../../module/util';
const { ccclass, property } = _decorator;

@ccclass('PrefabBase')
export class PrefabBase extends Component {
    
    @property({type: Node})
    private bg:Node|null=null;
    @property({type: Node})
    private scrollView:Node|null=null;

    private params:object|null=null;

    start () {
        // [3]
    }
    init(params:object|null=null){
        this.params = params;
    }

    onEnable(){
        let WinSize = view.getVisibleSize();
        if(this.bg){
            let u = this.bg.getComponent(UITransform);
            if(u){
                let bei = WinSize.x / u.width;
                let bei2 = WinSize.y / u.height;
                if(bei2 > bei){
                    bei = bei2;
                }
                this.bg.setScale(bei,bei);
            }
        }
        // 界面调整到顶部,且铺满屏幕可显示区域
        if(this.scrollView){
            this.scrollView.setPosition(0, WinSize.y/2);
            let u = this.scrollView.getComponent(UITransform);
            if(u){
                u.setContentSize(WinSize.x, WinSize.y-100);
                let viewUI = this.scrollView.getChildByName('view')?.getComponent(UITransform);
                if(viewUI){
                    viewUI.setContentSize(WinSize.x, WinSize.y-100);
                    let conUI = this.scrollView.getChildByName('view')?.getChildByName("content")?.getComponent(UITransform);
                    if(conUI){
                        conUI.setContentSize(WinSize.x, conUI.height);
                    }
                }
            }
        }
    }
    onDestroy(){
        
        Util.log("已销毁..."+ this.node.name);
    }
    // 后退按键
    onBackBtn(){
        let op = this.node.getComponent(UIOpacity);
        if(op){
            op.opacity = 255;
            Util.log("开始关闭动画");
            tween(op).to(0.2, {opacity:0}).start();
        }
        let pThis = this;
        tween(this.node).to(0.2, {position: new Vec3(view.getVisibleSize().x/2, 0, 0)}).delay(0.1).call(() => { 
            pThis.node.destroy();
            Util.log("已关闭...");
        }).start();
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}
