import { _decorator, Component, Node, log } from 'cc';
import { Util } from '../module/util';
import { Win } from './base/win';
import prefabManager from "./manager/prefabManager";
const { ccclass, property } = _decorator;
//import websocket from './network/websocket'
@ccclass('Main')
export class Main extends Win {
    // [1]
    // dummy = '';


    private preManager:prefabManager | undefined;

    start () {
        // [3]
        super.start();
        this.preManager = window.PrefabManager;
        if(this.preManager){
            this.preManager.showMenu('Menu');
            this.preManager.showPrefab('Zixun');
        }
            
    }
    // 改变窗体
    changeWin(name:string, params:object|null){
        Util.log('切换窗体:'+name);
        if(this.preManager != undefined){
            this.preManager.showPrefab(name,params); 
        }
    }
    // 显示dialog窗口
    showDialog(name:string,params:object|null = null){
        Util.log('显示Dialog:'+name);
        if(this.preManager != undefined){
            this.preManager.showDialogPrefab(name,params); 
        }
    }
    // 改变菜单
    changeMenu(name:string){
        Util.log('改变菜单:'+name);
        if(this.preManager != undefined){
            this.preManager.showMenu(name);
        }
    }
    // 显示提示框
    showMsg(txt:string,timer:number = 0){
        if(this.preManager)
            this.preManager.msg(txt,timer);
    }
    // 显示选择框
    showMsgBox(title:string, txt:string, isShowCannel:boolean=false, callback:Function|null=null, callback2:Function|null=null){
        if(this.preManager){
            this.preManager.msgBox(title, txt, isShowCannel, callback, callback2);
        }
    }
    cback(){
        Util.log('回调函数来了....');
    }
}
