
import { _decorator, Component, Node, view, UITransform, systemEvent, log, Toggle } from 'cc';
import { Util } from '../../module/util';
const { ccclass, property } = _decorator;

@ccclass('Menu')
export class Menu extends Component {
    // [1]
    // dummy = '';

    @property({type: Node})
    private bg:Node|null=null;

    start () {
        // [3]
    }
    onEnable(){
        if(this.bg){
            let WinSize = view.getVisibleSize();
            let u = this.bg.getComponent(UITransform);
            if(u){
                let bei = WinSize.x / u.width;
                this.bg.setScale(bei,bei);
            }
        }
    }
    onClickBtn(event: Event, type:string){
        let isCheck:boolean|undefined = false;
        if(event.target){
            isCheck = (<Node><unknown>event.target).getComponent(Toggle)?.isChecked;
        }
        if(isCheck){
            Util.log('选中:'+ type);
            systemEvent.emit("changeWin", type);
        }
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}
