
import { _decorator, Component, Node, log, Label, view, UITransform, tween, UIOpacity, Button, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Msgbox')
export class Msgbox extends Component {
    @property({type: Node})
    private notouchNode:Node|null = null;  // 截断触摸节点
    @property({type: Node})
    private typ1Node:Node|null = null;  // 弹窗类型1节点
    @property({type: Node})
    private txtbgNode:Node|null = null;  // 显示内容节点背景
    @property({type: Label})
    private txt:Label|null = null;  // 显示内容节点

    @property({type: Node})
    private typ2Node:Node|null = null;  // 弹窗类型2节点
    @property({type: Node})
    private txt2bgNode:Node|null = null;  // 显示内容节点背景
    @property({type: Label})
    private txt2:Label|null = null;  // 显示内容节点
    @property({type: Label})
    private title2:Label|null = null;  // 显示标题
    @property({type: Button})
    private yesBtn:Button|null = null;  // 确定按钮1(和取消按钮同时显示)
    @property({type: Button})
    private yesBtn2:Button|null = null;  // 确定按钮2
    @property({type: Button})
    private noBtn:Button|null = null;  // 取消按钮
    private yesCallback:Function|null = null;  // 确定按钮回调
    private noCallback:Function|null = null;  // 取消按钮回调
    
    start () {
        
    }
    showMsg(parms:any|null){
        if(parms && parms.type> 0){
            switch(parms.type){
                case 1:
                    this.showTyp1Msg(parms.txt, parms.time);
                break;
                case 2:
                    this.showTyp2Msg(parms.txt, parms.isShowCannel, parms.title, parms.callback, parms.callback2);
                break;
                default:

                    break;
            }
        }
        else{
            log('参数错误!!!' + parms);
        }
    }
    private showTyp1Msg(txt:string,time:number){
        if(this.notouchNode){
            this.notouchNode.active = false;
        }
        if(this.typ2Node){
            this.typ2Node.active = false;
        }
        if(this.txtbgNode && this.txt){
            var WinSize = view.getVisibleSize();
            var u = this.txtbgNode.getComponent(UITransform);
            this.txt.string = txt;
            this.txt.fontSize = 23;
            var pthis = this;
            // 下一帧执行改变背景宽度
            this.scheduleOnce(function () {
                log('改变宽度time='+time);
                if(u){
                    var txtUi = pthis.txt?.node.getComponent(UITransform);
                    if(txtUi){
                        u.width = txtUi.width + 40; // 两边各留20px空余
                    }
                    // 等比缩小
                    if(u.width > WinSize.x){
                        if(pthis.txt)
                            pthis.txt.fontSize *= ((WinSize.x-100) / u.width);
                        u.width = WinSize.x - 50;
                    }
                    if(pthis.txt)
                        log('fontsize='+pthis.txt.fontSize+' width='+u.width+'  length='+txt.length);
                }
            }.bind(this), 0);
        }
        if(this.typ1Node){
            time = time ? time : 2;
            this.typ1Node.active = true;
            var op = this.typ1Node.getComponent(UIOpacity);
            if(op){
                op.opacity = 0;
                // 执行动画
                tween(op) .to(0.25, {opacity: 255}).delay(time).to(0.2, {opacity: 0}) .call(() => { 
                    // 自我删除
                    this.close();
                    log("执行弹窗完毕");
                }) .start();
            } 
            
        }
            
    }
    private showTyp2Msg(txt:string,isShowCannel:boolean,title:string,callback:Function,callback2:Function){
        if(this.notouchNode){
            var WinSize = view.getVisibleSize();
            this.notouchNode.active = true;
            var u = this.notouchNode.getComponent(UITransform);
            if(u){
                u.setContentSize(WinSize);
            }
        }
        // 改变控件展示
        this.typ1Node ? this.typ1Node.active = false : 0;
        this.typ2Node ? this.typ2Node.active = true : 0;
        this.yesBtn ? this.yesBtn.node.active = isShowCannel : 0;
        this.yesBtn2 ? this.yesBtn2.node.active = !isShowCannel : 0;
        this.noBtn ? this.noBtn.node.active = isShowCannel : 0;
        // 赋值文字,并检查文字大小
        if(this.title2 && this.txt2){
            this.txt2.string = txt;
            this.txt2.fontSize = 28;
            this.title2.string = title;
            this.title2.fontSize = 30;
            var pthis = this;
            // 下一帧检查如果文字过宽则等比缩小字体大小
            this.scheduleOnce(function () {
                log('检查改变字体大小type2');
                var txtUi = pthis.txt2bgNode?.getComponent(UITransform);
                if(txtUi){
                    var maxWidth = txtUi.width - 50;
                    if(pthis.txt2){
                        var txt2UI = pthis.txt2.node.getComponent(UITransform);
                        // 等比缩小
                        if(txt2UI && txt2UI.width > maxWidth){
                            pthis.txt2.fontSize *= (maxWidth / txt2UI.width);
                            log('改变了txt的字体大小:'+pthis.txt2.fontSize);
                        }
                    }
                    if(pthis.title2){
                        var title2UI = pthis.title2.node.getComponent(UITransform);
                        // 等比缩小
                        if(title2UI && title2UI.width > maxWidth){
                            pthis.title2.fontSize *= (maxWidth / title2UI.width);
                            log('改变了title的字体大小:'+pthis.title2.fontSize);
                        }
                    }
                }
            }.bind(this), 0);
        }
        this.yesCallback = callback;
        this.noCallback = callback2;
        // 执行展示动画
        if(this.typ2Node){
            this.typ2Node.setScale(0,0);
            tween(this.typ2Node) .to(0.2, {scale: new Vec3(1,1,1)}) .start();
        }
    }
    private yesBtnClick(){
        if(this.yesCallback){
            this.yesCallback();
        }
        this.close();
    }
    private noBtnClick(){
        if(this.noCallback){
            this.noCallback();
        }
        this.close();
    }
    private close(){
        // 自我删除
        this.yesCallback = null;
        this.node.parent?.removeChild(this.node);
        this.node.destroy();
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}
