/*
 * @Description: 
 * @Author: pck
 * @Date: 2021-11-12 18:07:22
 * @Reference: 
 */

import { _decorator, Component, Node, Sprite, SpriteFrame, Prefab, Slider, Label, instantiate } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = Memorytest
 * DateTime = Fri Nov 12 2021 18:07:22 GMT+0800 (中国标准时间)
 * Author = kearos
 * FileBasename = memorytest.ts
 * FileBasenameNoExtension = memorytest
 * URL = db://assets/resources/memorytest.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */

@ccclass('Memorytest')
export class Memorytest extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;
    @property(SpriteFrame)
    spf!: SpriteFrame;

    @property(Prefab)
    pfb!: Prefab;

    @property(Node)
    item!: Node;

    @property(Node)
    panel!: Node;

    @property(Label)
    tip!: Label;

    private _mode: number = 0;
    private _testTemp: number = 2 + 0.016;
    private _dt = 0;
    start() {
        // [3]
    }

    update(deltaTime: number) {
        // [4]
        if (!this._mode) {
            return;
        }
        this._dt += deltaTime;
        if (this._dt >= this._testTemp) {
            this._doTest();
        }

    }
    _doTest() {
        this.panel.destroyAllChildren();
        for (let index = 0; index < 200; index++) {
            let node = this.getNodeByMode();
            if (node) {
                node.parent = this.panel;
                let r = Math.random() * 100;
                let angle = Math.sqrt(Math.random()) * Math.PI * 2;
                let y = Math.sin(angle) * r;
                let x = Math.cos(angle) * r;
                node?.setPosition(x, y);
            }
        }
    }
    clickMode(btn: Event, data: any) {
        console.log('data', +data);
        this._mode = +data;
        this.tip.string = ['代码创建模式', '预制体模式', '节点模式'][this._mode - 1]
    }

    speedChange(slid: Slider) {
        this._testTemp = 2 * slid.progress + 0.016;
    }

    getNodeByMode() {
        if (this._mode === 1) {
            let node = new Node();
            node.layer = this.panel.layer;
            let sprite = node.addComponent(Sprite);
            sprite.sizeMode = Sprite.SizeMode.RAW;
            return node;
        } else if (this._mode == 2) {
            let node = instantiate(this.pfb);
            return node;
        } else if (this._mode == 3) {
            let node = instantiate(this.item);
            return node;
        }
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.3/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.3/manual/zh/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.3/manual/zh/scripting/life-cycle-callbacks.html
 */
