import { _decorator, Component, Node } from 'cc';
import * as cc from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Test')
export default class Test extends cc.Component {
    @property(cc.Prefab)
    private prefab: cc.Prefab;
    private objs: cc.Node[] = new Array();
    private pool: cc.NodePool = new cc.NodePool();

    onEnable() {
        let rd = this.randomNumber(500, 1000);
        for (let i = 0; i < rd; i++) {
            let obj = this.getObj();
            let sprite = obj.getComponent(cc.Sprite);
            sprite.color = this.randomColor();
        }
    }

    onDisable() {
        while (this.objs.length > 0) {
            let obj = this.objs[0];
            obj.active = false;
            this.objs.splice(0, 1);
            this.pool.put(obj);
        }
    }


    private getObj(): cc.Node {
        if (this.pool.size() == 0) {
            let obj = cc.instantiate(this.prefab);
            this.pool.put(obj);
        }
        let obj = this.pool.get();
        obj.active = true;
        obj.setParent(this.node);
        this.objs.push(obj);
        return obj;
    }


    private randomNumber(min: number, max: number): number {
        min = Math.ceil(min);
        max = Math.floor(max);
        return Math.floor(Math.random() * (max - min) + min);
    }

    private randomColor(): cc.Color {
        let color = this.randomNumber(0, 6);
        switch (color) {
            case 0:
                return cc.Color.RED;
            case 1:
                return cc.Color.GREEN;
            case 2:
                return cc.Color.BLUE;
            case 3:
                return cc.Color.CYAN;
            case 4:
                return cc.Color.MAGENTA;
            default:
                return cc.Color.YELLOW;
        }
    }
}

