import { _decorator, Component, Node } from 'cc';
import * as cc from 'cc';
const { ccclass, property } = _decorator;

@ccclass('TestControl')
export default class TestControl extends cc.Component {
    @property(cc.Node)
    private nodeA: cc.Node;
    @property(cc.Node)
    private nodeB: cc.Node;

    @property(cc.Node)
    autoStartNode: cc.Node;
    @property(cc.Node)
    autoStopNode: cc.Node;
    private repeatTween: cc.Tween<Node>;

    start() {
        this.autoStartNode.on("click", this.clickAutoStart, this.autoStartNode);
        this.autoStopNode.on("click", this.clickAutoStop, this.autoStopNode);
        cc.input.on(cc.Input.EventType.KEY_DOWN, this.testInputKeyBoard, this);
    }

    testInputKeyBoard(event: cc.EventKeyboard) {
        let v = new cc.NodePool();
        switch (event.keyCode) {
            case cc.KeyCode.ARROW_LEFT:
                this.nodeA.active = false;
                this.nodeB.active = true;
                break;
            case cc.KeyCode.ARROW_RIGHT:
                this.nodeA.active = true;
                this.nodeB.active = false;
                break;
        }
    }

    clickAutoStart = () => {
        this.clickAutoStop();
        this.repeatTween = cc.tween(this.node)
            .repeatForever(
                cc.tween(this.node)
                    .delay(0.1)
                    .call(() => {
                        if (this.nodeA.active) {
                            this.nodeA.active = false;
                            this.nodeB.active = true;
                        } else {
                            this.nodeA.active = true;
                            this.nodeB.active = false;
                        }
                    })
            )
            .start();
    }

    clickAutoStop = () => {
        if (this.repeatTween)
            this.repeatTween.stop();
    }
}

