
import { _decorator, Component, Node, find, UITransform, Size, Layers } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = NewComponent
 * DateTime = Tue Aug 31 2021 15:37:43 GMT+0800 (中国标准时间)
 * Author = Koei
 * FileBasename = NewComponent.ts
 * FileBasenameNoExtension = NewComponent
 * URL = db://assets/NewComponent.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */
 
@ccclass('NewComponent')
export class NewComponent extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    start () {
        // [3]
        let sp = find('Canvas/Sprite');
        let touchNode = new Node();
        touchNode.addComponent(UITransform).setContentSize(new Size(100,100));
        sp?.addChild(touchNode);
        touchNode.layer = Layers.Enum.UI_2D;
        touchNode?.on(Node.EventType.TOUCH_START,this.onTouchBegan,this);
        touchNode?.on(Node.EventType.TOUCH_MOVE,this.onTouchMoved,this);
        touchNode?.on(Node.EventType.TOUCH_END,this.onTouchEnded,this);
        touchNode?.on(Node.EventType.TOUCH_CANCEL,this.onTouchCancel,this);

    }

    onTouchBegan(){
        console.log('onTouchBegan')
    }

    onTouchMoved(){
        console.log('onTouchMoved')
    }

    onTouchEnded(){
        console.log('onTouchEnded')
    }

    onTouchCancel(){
        console.log('onTouchCancel')
    }


    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.3/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.3/manual/zh/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.3/manual/zh/scripting/life-cycle-callbacks.html
 */
