// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

import { _decorator, Component, Node, EventTouch, geometry, Vec2, PhysicsSystem, PhysicsRayResult, Vec3, Camera, RigidBody } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Main')
export class Main extends Component {
    /* class member could be defined like this */
    // dummy = '';

    /* use `property` decorator if your want the member to be serializable */
    // @property
    // serializableDummy = 0;

    @property(Camera)
    public mainCamera:Camera | null = null;

    @property(Node)
    public touchPlane:Node | null = null;

    @property(RigidBody)
    public rigd1:RigidBody = null;

    @property(RigidBody)
    public rigd2:RigidBody = null;

    start () {
        // Your initialization goes here.

        if(this.touchPlane)
        {
            this.touchPlane.on(Node.EventType.TOUCH_START,this.onTouchPlane,this);
        }
        
        console.log("myLayer",this.node.layer,this.rigd1.group,this.rigd2.group)

    }

    private onTouchPlane(event:EventTouch)
    {
        var mousePosition:Vec2 = event.getLocation();
        var ray:geometry.Ray = new geometry.Ray();

        if(this.mainCamera)
        {
            this.mainCamera.screenPointToRay(mousePosition.x,mousePosition.y,ray);
        }


        
        //检测是否点击到地面
        //if(PhysicsSystem.instance.raycastClosest(ray,1 << 1)) //如果第二个参数mask是指渲染层，用 1 << 1 （2） : 检测结果检测不到地面
        if(PhysicsSystem.instance.raycastClosest(ray,1 << 2)) //如果第二个参数mask是指物理碰撞层，用 1 << 2 （4）: 检测结果检测也不到地面
        {
            var rayResult:PhysicsRayResult = PhysicsSystem.instance.raycastClosestResult;

            var hitPoint:Vec3 = rayResult.hitPoint;

            console.log("射线碰撞到对象 collider",rayResult.collider.node.name);
        }

        


    }
    // update (deltaTime: number) {
    //     // Your update function goes here.
    // }
}
