import { _decorator, Component, Node, SliderComponent, SkinningModelComponent, ModelComponent } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('SliderCtrl')
export class SliderCtrl extends Component {

    @property(Node)
    SET_Node:Node=null;//修改材质参数
    @property(Node)
    SET_Node2:Node=null;//修改材质参数

    @property(SliderComponent)
    slider: SliderComponent | null = null;

    onLoad(){
       this.slider.node.on('toggle', this.callback, this);
    }

    callback(){
        console.log(this.slider.progress*0.3);

        this.SET_Node.getComponent(SkinningModelComponent).material.setProperty("step_edge",this.slider.progress*2);
        this.SET_Node2.getComponent(ModelComponent).material.setProperty("step_edge",this.slider.progress*2);
        // 回调的参数是 slider 组件，注意这种方式注册的事件，无法传递 customEventData
    }

}
