

import { _decorator, Component, Node, EventTouch, EventHandler, Vec3, UITransform, Rect, Vec2, sp, director, Camera, view, screen, Size } from 'cc';
import { Event, GRoot } from 'fairygui-cc';
import { Vec2Pool } from '../utils/Pool';
import { UtilsHelper } from '../utils/UtilsHelper';
import { TouchController } from './touch_controller';
const { ccclass, property } = _decorator;

@ccclass('TouchButton')
export class TouchButton extends Component {
    @property(EventHandler)
    onClick: EventHandler[] = [];

    private _startPos: Vec2 = new Vec2();
    private _transform: UITransform;
    onLoad(){            
        this._transform = this.node.getComponent(UITransform);   
    }

    onEnable() {
        TouchController.I.addTouchBegin(this.onTouchStart, this);
        TouchController.I.addTouchEnd(this.onTouchEnd, this);
    }

    onDisable() {
        TouchController.I.removeTouchBegin(this.onTouchStart, this);
        TouchController.I.removeTouchEnd(this.onTouchEnd, this);
    }

    private contains(e: Event) {
        let pos = Vec2Pool.get();
        let bb = this._transform.getBoundingBox();
        UtilsHelper.groot2cnode(e.pos, this.node.parent, pos);
        let ret = pos.x >= bb.xMin && pos.x <= bb.xMax && pos.y >= bb.yMin && pos.y <= bb.yMax;   
        Vec2Pool.put(pos);
        return ret;
    }

    private canUse() {
        return this.enabled;
    }

    onTouchStart(e: Event) {
        if (!this.canUse()) {
            return;
        }

        if (this.contains(e)) {
            this._startPos.set(e.pos);
            e.propagationImmediateStopped = true;
        }

    }

    onTouchEnd(e: Event) {
        if (!this.canUse()) {
            return;
        }

        if (this.contains(e)) {
            s_vec2.set(e.pos);
            if(Vec2.distance(s_vec2, this._startPos) < 20) {
                for (let i = 0; i < this.onClick.length; ++i) {
                    this.onClick[i].emit([]);
                }
                e.propagationImmediateStopped = true;
            }
        }

    }
}
var s_vec2 = new Vec2;