
import { _decorator, Component, Node, EventTouch, UITransform, Vec3, EventHandler, Vec2, Camera } from 'cc';
import { GObject, GRoot, Event } from 'fairygui-cc';
const { ccclass, property } = _decorator;

type FEventHandler = (Event)=>void;
type FEventHandlerWarpper = {
    handler: FEventHandler;
    thisObj: any;
};

@ccclass('TouchController')
export class TouchController extends Component {
    static I: TouchController = null;

    private _touchBeginHandler: FEventHandlerWarpper[] = [];
    private _touchMoveHandler: FEventHandlerWarpper[]= [];
    private _touchEndHandler: FEventHandlerWarpper[]= [];

    touchEnable = true;
    
    private _hook: GObject = null;
    onLoad() {
        TouchController.I = this;
    }

    setHook(hook: GObject) {
        if(this._hook) {
            this._hook.off(Event.TOUCH_BEGIN, this.onTouchBegin, this);
            this._hook.off(Event.TOUCH_MOVE, this.onTouchMove, this);
            this._hook.off(Event.TOUCH_END, this.onTouchEnd, this);
        }
        this._hook = hook;
        this._hook.on(Event.TOUCH_BEGIN, this.onTouchBegin, this);
        this._hook.on(Event.TOUCH_MOVE, this.onTouchMove, this);
        this._hook.on(Event.TOUCH_END, this.onTouchEnd, this);
    }

    private onTouchBegin(evt: Event) {
        if(!this.touchEnable) {
            return;
        }

        this._touchBeginHandler.forEach(h=>{
            h.handler.call(h.thisObj, evt);
        });
    }

    private onTouchMove(evt: Event) {
        if(!this.touchEnable) {
            return;
        }

        this._touchMoveHandler.forEach(h=>{
            h.handler.call(h.thisObj, evt);
        });
    }

    private onTouchEnd(evt: Event) {        
        if(!this.touchEnable) {
            return;
        }

        this._touchEndHandler.forEach(h=>{
            h.handler.call(h.thisObj, evt);
        });
    }

    addTouchBegin(handler: FEventHandler, thisObj?: any) {
        this._touchBeginHandler.push({
            handler,
            thisObj,
        });
    }

    addTouchMove(handler: FEventHandler, thisObj?: any) {
        this._touchMoveHandler.push({
            handler,
            thisObj,
        });
    }

    addTouchEnd(handler: FEventHandler, thisObj?: any) {
        this._touchEndHandler.push({
            handler,
            thisObj,
        });
    }

    removeTouchBegin(handler: FEventHandler, thisObj?: any) {
        let idx = this._touchBeginHandler.findIndex((it)=>it.handler == handler && thisObj == it.thisObj);
        if(idx >= 0) {
            this._touchBeginHandler.splice(idx, 1)
        }
    }

    removeTouchMove(handler: FEventHandler, thisObj?: any) {
        let idx = this._touchMoveHandler.findIndex((it)=>it.handler == handler && thisObj == it.thisObj);
        if(idx >= 0) {
            this._touchMoveHandler.splice(idx, 1)
        }
    }

    removeTouchEnd(handler: FEventHandler, thisObj?: any) {
        let idx = this._touchEndHandler.findIndex((it)=>it.handler == handler && thisObj == it.thisObj);
        if(idx >= 0) {
            this._touchEndHandler.splice(idx, 1)
        }
    }
}