import { _decorator, Component, Node, Material, EffectAsset, sp } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Draw')
export class Draw extends Component {
  @property(EffectAsset)
  effect: EffectAsset = null!;

  dissolveThreshold = 0;

  spComp: sp.Skeleton = null;
  mat: Material = null;
  dissolve = true;
  handle = -1;
  materialCache: any;

  start() {
    this.spComp = this.getComponent(sp.Skeleton);
    this.mat = this.spComp.customMaterial;
    console.log(this.mat.passes);
    this.materialCache = this.spComp._materialCache;

    // 这样可以
    // this.mat.setProperty('dissolveThreshold', 0.5);
  }
  processPass(pass) {
    this.handle = pass.getHandle('dissolveThreshold');
    pass.setUniform(this.handle, this.dissolveThreshold);
    pass.update();
    // this.spComp.customMaterial = this.mat
  }
  update(deltaTime: number) {
    if (this.dissolve) {
      this.dissolveThreshold += 0.5 * deltaTime;
      if (this.dissolveThreshold > 1) {
        this.dissolveThreshold = 1;
        this.dissolve = false;
      }
    }
    for (let i in this.materialCache) { 
      let material= this.materialCache[i];
      let pass = material.passes[0];
      this.processPass(pass);
    }
  }
}
