import { animation, Component, Vec2, Vec3, _decorator } from 'cc';
import Joystick from './Joystick';
const { ccclass, property } = _decorator;

@ccclass('Animator')
export class Animator extends Component {
    protected controller: animation.AnimationController = null!;
    @property({ displayName: "摇杆脚本所在节点", tooltip: "摇杆脚本Joystick所在脚本", type: Joystick })
    joy: Joystick = null!;
    moveSpeed = 3;

    ani = ""
    start() {
        this.controller = this.node.getComponentInChildren(animation.AnimationController)!;
        this.playAni("rest");
    }

    playAni(type: string, callback?: Function, caller?: Component): void {
        if (this.ani != type) {
            this.controller.setValue(type, true)
            this.ani = type;
            console.info("playAni", "idle", this.controller.getValue("idle"), "run", this.controller.getValue("run"))
        }
    }

    private movemenet = new Vec3();
    update(dt: number) {
        if (this.joy.vector.equals(Vec2.ZERO)) {
            if (this.ani != "idle") {
                this.playAni("idle");
            }
            return
        }
        let dir = this.joy.vector.normalize();
        this.movemenet.x = -this.moveSpeed * dir.x * dt;
        this.movemenet.z = this.moveSpeed * dir.y * dt;
        this.node.translate(this.movemenet);
        this.setAngle(this.getAngle(dir) - 90)
        this.playAni('run')
    }

    public setAngle(angleY: number): void {
        let r = this.node.rotation;
        this.controller.node.setRotationFromEuler(r.x, angleY, r.z);
    }

    public getAngle(v: Vec2) {
        var a = Math.atan2(v.y, v.x);
        var ret = a * 180 / Math.PI; //弧度转角度，方便调试
        if (ret > 360) {
            ret -= 360;
        }
        if (ret < 0) {
            ret += 360;
        }
        return ret;
    }
}


