import { Component, Enum, EventMouse, IVec3Like, Node, Quat, Vec3, _decorator } from "cc";
const { ccclass, property } = _decorator;

export enum ThirdPersonCameraType {
	/** 相机紧跟随着目标，相机不会旋转 */
	Follow = 0,
	/** 相机会旋转紧跟着目标正后方，旋转不可控制 */
	FollowTrackRotation = 1,
	/** 相机紧跟随着目标，相机可以自由旋转 */
	FollowIndependentRotation = 2,
}

/**
 * 第三人称相机跟随
 * 这里总结了三个相机跟随
 * 1. 相机紧跟随着目标，相机不会旋转
 * 2. 相机紧跟随着目标，相机会旋转紧跟着目标正后方，旋转不可控制
 * 3. 相机紧跟随着目标，相机可以自由旋转，角色向前移动的时候，前方向永远是相机的正方向
 */
@ccclass('CameraCtl')
export class CameraCtl extends Component {
	/** 目标 */
	@property(Node)
	target: Node = null!;
	/** 注视的目标，这里我想让相机对准目标的上方一点，所有多加了注视（相机正对着）的目标 */
	@property(Node)
	lookAt: Node = null!;
	@property({ type: Enum(ThirdPersonCameraType) })
	cameraType: ThirdPersonCameraType = ThirdPersonCameraType.Follow;
	/** 距离目标距离 */
	@property
	positionOffset: Vec3 = new Vec3(0, 10, 8);
	/** 移动差值移动系数 */
	@property
	moveSmooth: number = 0.02;
	/** 差值旋转系数 */
	@property
	rotateSmooth: number = 0.03;

	public MouseX: number = 0;
	public MouseY: number = 0;

	private _forward: Vec3 = new Vec3();
	private _right: Vec3 = new Vec3();
	private _up: Vec3 = new Vec3();
	private angle: IVec3Like = null!;



	start() {
		// input.on(Input.EventType.MOUSE_DOWN, this.MouseDown, this);
		// input.on(Input.EventType.MOUSE_MOVE, this.MouseMove, this);
		// input.on(Input.EventType.MOUSE_UP, this.MouseUp, this);
		this.cameraType == ThirdPersonCameraType.Follow && this.node.lookAt(this.target.worldPosition);
	}

	isDown: boolean = false;
	private MouseDown(e: EventMouse) {
		this.isDown = true;
	}

	private MouseMove(e: EventMouse) {
		if (this.cameraType == ThirdPersonCameraType.FollowIndependentRotation) {
			this.SetIndependentRotation(e);
		}
	}

	private MouseUp(e: EventMouse) {
		this.isDown = false;
	}

	update(dt: number) {
		if (this.target) {
			switch (this.cameraType) {
				case ThirdPersonCameraType.Follow:
					this.SetFollow();
					break;
				case ThirdPersonCameraType.FollowTrackRotation:
					this.SetFollowTrackRotation();
					break;
				case ThirdPersonCameraType.FollowIndependentRotation:
					this.SetMove();
					break;
			}

		}
	}
	temp: Vec3 = new Vec3();
	temp1: Vec3 = new Vec3();
	private SetFollow() {
		Vec3.add(this.temp, this.lookAt.worldPosition, this.positionOffset);
		this.node.position = this.node.position.lerp(this.temp, this.moveSmooth);
		// this.node.lookAt(this.target.worldPosition, Vec3.UP);
	}

	private velocity = new Vec3();
	private forwardView: Vec3 = new Vec3();
	/**
	 * 
	 */
	private SetFollowTrackRotation() {
	}

	/*************************FollowIndependentRotation***************** */

	/**
	 * 实时设置相机距离目标的位置position
	 */
	public SetMove() {
		this._forward.set(0, 0, 0);
		this._right.set(0, 0, 0);
		this._up.set(0, 0, 0);
		Vec3.transformQuat(this._forward, Vec3.FORWARD, this.node.rotation);
		//Vec3.transformQuat(this._right, Vec3.RIGHT, this.node.rotation);
		//Vec3.transformQuat(this._up, Vec3.UP, this.node.rotation);

		this._forward.multiplyScalar(this.positionOffset.z);
		//this._right.multiplyScalar(this.positionOffset.x);
		//this._up.multiplyScalar(this.positionOffset.y);
		this.temp = this.temp.add(this.lookAt.worldPosition).subtract(this._forward).add(this._right).add(this._up);
		this.node.position = this.node.position.lerp(this.temp, this.moveSmooth);
	}

	_quat: Quat = new Quat();
	/**
	 * 计算根据鼠标X，Y偏移量来围绕X轴和Y轴的旋转四元数
	 * @param e 
	 */
	private SetIndependentRotation(e: EventMouse) {

	}

	/*************************FollowIndependentRotation end***************** */

	private Clamp(val: number, min: number, max: number) {
		if (val <= min) val = min;
		else if (val >= max) val = max;
		return val;
	}

	public GetType(): ThirdPersonCameraType {
		return this.cameraType;
	}
}