import { _decorator, Component, Label, Node, RichText, sp, Sprite, SpriteFrame } from 'cc';
import { txt } from './TxtMgr';
import I18Mgr from './I18Mgr';
import EventCenter from '../kernel/core/event/EventCenter';

const { ccclass, property } = _decorator;

@ccclass('I18Cmpt')
export class I18Cmpt extends Component {

    @property
    _key:string = "";

    @property
    get key(){
        return this._key;
    }

    set key( v: string ){
        const self = this;
        if( self._key == v ) return;
        self._key = v;

        self.refreshByI18();
    }

    @property({
        visible:true,
        tooltip: "是否自动刷新\n如果代码控制显示内容,则为false"
    })
    _refresh = true;

    _refreshedByI18 = false;

    protected onLoad(): void {
        const self = this;
        EventCenter.getInstance().listen( "I18BundleReady", self.onI18BundleReady, self );
    }

    protected onEnable(){
        const self = this;
        const sprite : Sprite = self.node.getComponent( Sprite );
        if( sprite ){
            sprite.sizeMode = Sprite.SizeMode.RAW;
            sprite.trim = false;
        }
        
        if( self._refresh ){
            this.refreshByI18();
        }
    }

    protected onDestroy(): void {
        const self = this;
        EventCenter.getInstance().removeByTarget( self );
    }

    onI18BundleReady(){
        const self = this;
        if( !self.isValid ) return;
        if( !self._refresh ) return;

        self._refreshedByI18 = false;
        self.refreshByI18();
    }

    refreshByI18(){
        const self = this;

        if( self._refreshedByI18 ) return;
        self._refreshedByI18 = true;

        self.refresh();
    }

    refresh(){
        const self = this;

        if( self._key == "" ) return;

        const i18 = I18Mgr.getInstance();
        if( !i18.isReady() ) return;
        
        const lb = self.node.getComponent(Label);
        if( lb ){
            lb.string = txt( self._key );
            return;
        }

        const lbRich = self.node.getComponent( RichText );
        if( lbRich ){
            lbRich.string = txt( self._key );
            return;
        }

        const sprite : Sprite = self.node.getComponent( Sprite );
        if( sprite ){
            i18.getRes( self._key + "/spriteFrame", SpriteFrame, ( err, spriteFrame:SpriteFrame )=>{
                if( err ) return;
                if( !self.isValid ) return;
                sprite.spriteFrame = spriteFrame;
                sprite.sizeMode = Sprite.SizeMode.RAW;
                sprite.trim = false;
            } );
            return;
        }

        const spine = self.node.getComponent( 'sp.Skeleton' ) as sp.Skeleton;
        if( spine ){
            i18.getRes( self._key, sp.SkeletonData, (err: Error, skeletonData: sp.SkeletonData)=>{
                if( err ) return;
                if( !self.isValid ) return;                

                if( spine._skeleton.skin ){                    
                    const skin = spine._skeleton.skin.name;
                    spine.skeletonData = skeletonData;
                    spine.setSkin( skin );
                }

                let animName = ""
                let loop = false;
                const trackEntry = spine.getCurrent(0);
                if( trackEntry ){
                    loop = trackEntry.loop;
                    if( trackEntry.animation ){
                        animName = trackEntry.animation.name;
                    }
                }
                if( animName != "" ){
                    spine.setAnimation( 0, animName, loop );
                }
            });
            return;
        }
    }

}