import { JsonAsset } from "cc";

export default class TxtMgr {

    static url:string = "txt";
    static instance : TxtMgr = null;
    static getInstance(): TxtMgr{
        if( TxtMgr.instance == null ){
            TxtMgr.instance = new TxtMgr();
        }
        return TxtMgr.instance;
    }

    data: any = null;
    setData( data: JsonAsset ){
        this.data = data.json;
    }

    getTxt( key: string, ...params ) : string {
        const self = this;

        if( self.data == null ){
            let result = key;
            for( const str of params ){
                result += " " + str;
            }
            return result;
        }

        let txtData = null;
        if( key.indexOf("etxt") != 0 ){
            txtData = self.data;
        }else{
            txtData = self.data[ "zzz___editor_txt___" ];
        }

        if( txtData == null || txtData[key] == null ){
            let result = key;
            for( const str of params ){
                result += " " + str;
            }
            return result;
        }

        let result = txtData[key].replace( '\'', "\"" );
        for( let i=0; i<params.length; ++i ){
            result = result.replace( `{${i+1}}`, params[i].toString() );
        }
        return result;
    }

//    static getRoomName( fullName ){
//         let name = fullName.replace( "勇者之路", TxtMgr.getInstance().getTxt( "勇者之路" ) );
//         name = name.replace( "小试牛刀", TxtMgr.getInstance().getTxt( "小试牛刀" ) );
//         return name;
//     }

//     static getNumSimpleTxt( num:number, bundleName:string ){
//         switch( bundleName ){
//             case EBundleName.CN:
//                 {
//                     if( num >= 100000000 ){
//                         return txt( "num_unit_yi", (num / 100000000) )
//                     }else if( num > 10000 ){
//                         return txt( "num_unit_w", (num / 10000) )
//                     }else{
//                         return num.toString();
//                     }
//                 }
//             break;
//             default:
//                 {
//                     if( num > 1000000000 ){
//                         return txt( "num_unit_b", (num / 1000000000) )
//                     }else if( num > 1000000 ){
//                         return txt( "num_unit_m", (num / 1000000) )
//                     }else if( num > 1000 ){
//                         return txt( "num_unit_k", (num / 1000) )
//                     }else{
//                         return num.toString();
//                     }
//                 }
//             break;
//         }
//     }
}

export const txt = function( key: string, ...params ){
    return TxtMgr.getInstance().getTxt( key, ...params );
}