// Learn TypeScript:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/life-cycle-callbacks.html

import DaoJuItem from "./DaoJuItem";

const { ccclass, property } = cc._decorator;

@ccclass
export default class DIYManager {
    public static _s_instance: DIYManager | null = null;
    public static getInstance(): DIYManager {
        if (!this._s_instance)
            this._s_instance = new DIYManager();
        return this._s_instance;
    }

    changeAll(renwu: DaoJuItem) {
        this.change_tf(renwu);
        this.change_waitao(renwu);
        this.change_bao(renwu);
        this.change_huzi(renwu);
        this.change_mianju(renwu);
        this.change_xianglian(renwu);
        this.change_yanjing(renwu);
        this.change_mianwen(renwu);
        this.change_yf(renwu);
        this.change_ts(renwu);
        this.change_xie(renwu);

    }


    //test
    currIndex: number = 1;

    change_tf(renwu: DaoJuItem, __index: string = "") {
        console.log("huanzhuang-tf")

        let _index = renwu._info.tf.split("_")[1];

        if (__index == "") {
            _index = renwu._info.tf.split("_")[1];
        } else {
            _index = __index;
        }

        cc.resources.load("yf/tf_h/tf_h_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "tf_h")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/tf_q/tf_q_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "tf_q")
            } else {
                console.log("err", err);
            }
        });

        cc.resources.load("yf/tf_h_zhuangshi/tf_h_zhuangshi_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "tf_h_zhuangshi")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/tf_q_zhuangshi/tf_q_zhuangshi_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "tf_q_zhuangshi")
            } else {
                console.log("err", err);
            }
        });
    }

    change_waitao(renwu: DaoJuItem, __index: string = "") {
        console.log("huanzhuang-waitao")
        let _index = renwu._info.waitao.split("_")[1];
        if (__index == "") {
            _index = renwu._info.waitao.split("_")[1];
        } else {
            _index = __index;
        }
        cc.resources.load("yf/waitao_h_shangyi/waitao_h_shangyi_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "waitao_h_shangyi")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/waitao_q_db_y/waitao_q_db_y_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "waitao_q_db_y")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/waitao_q_db_z/waitao_q_db_z_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "waitao_q_db_z")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/waitao_q_dt_y/waitao_q_dt_y_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "waitao_q_dt_y")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/waitao_q_dt_z/waitao_q_dt_z_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "waitao_q_dt_z")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/waitao_q_shangyi/waitao_q_shangyi_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "waitao_q_shangyi")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/waitao_q_xb_y/waitao_q_xb_y_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "waitao_q_xb_y")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/waitao_q_xb_z/waitao_q_xb_z_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "waitao_q_xb_z")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/waitao_q_xiayi/waitao_q_xiayi_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "waitao_q_xiayi")
            } else {
                console.log("err", err);
            }
        });
    }

    change_bao(renwu: DaoJuItem, __index: string = "") {
        console.log("huanzhuang-bao")
        let _index = renwu._info.shoutibao.split("_")[1];
        if (__index == "") {
            _index = renwu._info.shoutibao.split("_")[1];
        } else {
            _index = __index;
        }
        cc.resources.load("yf/bao_h/bao_h_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "bao_h")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/bao_q/bao_q_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "bao_q")
            } else {
                console.log("err", err);
            }
        });
    }
    change_huzi(renwu: DaoJuItem, __index: string = "") {
        console.log("huanzhuang-huzi")
        let _index = renwu._info.huzi.split("_")[1];
        if (__index == "") {
            _index = renwu._info.huzi.split("_")[1];
        } else {
            _index = __index;
        }
        cc.resources.load("yf/huzi_h/huzi_h_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "huzi_h")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/huzi_q/huzi_q_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "huzi_q")
            } else {
                console.log("err", err);
            }
        });
    }

    change_mianju(renwu: DaoJuItem, __index: string = "") {
        console.log("huanzhuang-mianju")
        let _index = renwu._info.mianju.split("_")[1];
        if (__index == "") {
            _index = renwu._info.mianju.split("_")[1];
        } else {
            _index = __index;
        }
        cc.resources.load("yf/mianju/mianju_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "mianju")
            } else {
                console.log("err", err);
            }
        });
    }

    change_xianglian(renwu: DaoJuItem, __index: string = "") {
        console.log("huanzhuang-xianglian")
        let _index = renwu._info.xl.split("_")[1];
        if (__index == "") {
            _index = renwu._info.xl.split("_")[1];
        } else {
            _index = __index;
        }
        cc.resources.load("yf/xianglian_q/xianglian_q_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "xianglian_q")
            } else {
                console.log("err", err);
            }
        });
    }

    change_yanjing(renwu: DaoJuItem, __index: string = "") {
        console.log("huanzhuang-yanjing")
        let _index = renwu._info.glasses.split("_")[1];
        if (__index == "") {
            _index = renwu._info.glasses.split("_")[1];
        } else {
            _index = __index;
        }
        cc.resources.load("yf/yanjing/yanjing_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "yanjing")
            } else {
                console.log("err", err);
            }
        });
    }

    change_mianwen(renwu: DaoJuItem, __index: string = "") {
        console.log("huanzhuang-mianwen")
        let _index = renwu._info.mianwen.split("_")[1];
        if (__index == "") {
            _index = renwu._info.mianwen.split("_")[1];
        } else {
            _index = __index;
        }
        cc.resources.load("yf/mianwen/mianwen_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "mianwen")
            } else {
                console.log("err", err);
            }
        });
    }


    change_yf(renwu: DaoJuItem, __index: string = "") {
        console.log("huanzhuang-yf")
        let _index = renwu._info.yf.split("_")[1];
        if (__index == "") {
            _index = renwu._info.yf.split("_")[1];
        } else {
            _index = __index;
        }
        cc.resources.load("yf/yf_q_db_y/yf_q_db_y_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "yf_q_db_y")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/yf_q_db_z/yf_q_db_z_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "yf_q_db_z")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/yf_q_dt_y/yf_q_dt_y_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "yf_q_dt_y")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/yf_q_dt_z/yf_q_dt_z_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "yf_q_dt_z")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/yf_q_kua/yf_q_kua_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "yf_q_kua")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/yf_q_shangyi/yf_q_shangyi_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "yf_q_shangyi")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/yf_q_xb_y/yf_q_xb_y_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "yf_q_xb_y")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/yf_q_xb_z/yf_q_xb_z_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "yf_q_xb_z")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/yf_q_xiayi/yf_q_xiayi_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "yf_q_xiayi")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/yf_q_xt_y/yf_q_xt_y_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "yf_q_xt_y")
            } else {
                console.log("err", err);
            }
        });
        cc.resources.load("yf/yf_q_xt_z/yf_q_xt_z_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {

            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "yf_q_xt_z")
            } else {
                console.log("err", err);
            }
        });
    }

    change_ts(renwu: DaoJuItem, __index: string = "") {
        let _index = renwu._info.wangguan.split("_")[1];
        if (__index == "") {
            _index = renwu._info.wangguan.split("_")[1];
        } else {
            _index = __index;
        }


        cc.resources.load("yf/ts_q/ts_q_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "ts_q")
            }
        });
    }
    change_xie(renwu: DaoJuItem, __index: string = "") {
        let _index = renwu._info.xie.split("_")[1];
        if (__index == "") {
            _index = renwu._info.xie.split("_")[1];
        } else {
            _index = __index;
        }


        cc.resources.load("yf/xie_h_y/xie_h_y_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "xie_h_y")
            }
        });
        cc.resources.load("yf/xie_h_z/xie_h_z_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "xie_h_z")
            }
        });
        cc.resources.load("yf/xie_q_y/xie_q_y_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "xie_q_y")
            }
        });
        cc.resources.load("yf/xie_q_z/xie_q_z_" + _index, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (!err) {
                this.updatePartialSkin(renwu, renwu.ani, spriteFrame, null, "xie_q_z")
            }
        });
    }

    private makeRegionIno(frame: cc.SpriteFrame, key: string = "") {
        if (frame == null) {
            return null;
        }
        let texture = frame.getTexture()
        let rect = frame.getRect()
        let origSize = frame.getOriginalSize()
        let offset = frame.getOffset()
        let rotate = frame.isRotated();

        console.log(rect.x, "-", rect.y, "-", rect.width, "-", rect.height);
        console.log(origSize.width, "-", origSize.height);
        console.log(offset.x, "-", offset.y);

        // 15 '-' 0 '-' 88 '-' 80
        // 118 '-' 136
        // 0 '-' 28

        // 0 '-' 0 '-' 118 '-' 136
        // 118 '-' 136
        // 0 '-' 0

        let info = {
            key: key,
            rect: rect,
            origSize: origSize,
            // offset: cc.v2(
            //     (origSize.width - rect.width) * 0.5 + offset.x,
            //     (origSize.height - rect.height) * 0.5 + offset.y
            // ),
            offset: cc.v2(
                0,
                0
            ),
            degrees: rotate ? 270 : 0,
            texture: texture,
            frame: frame
        }
        return info
    }


    updatePartialSkin(_renwu: DaoJuItem, ani: sp.Skeleton, tex2d: cc.SpriteFrame, slotChange: sp.spine.Slot, slotsName: string = "") {


        // 初始化副本（仅第一次需要创建）
        if (!_renwu.skeletonCopy) {
            this.copySkeletonData(_renwu, ani, ani.skeletonData, true); // 创建初始副本
            _renwu.skeletonCopy = ani.skeletonData; // 保存副本引用
        }

        // let _data = ani.skeletonData;
        // this.copySkeletonData(ani, _data, true);

        let slot!: sp.spine.Slot;
        if (slotChange) {
            slot = slotChange;
        }
        else {
            slot = ani.findSlot(slotsName) as sp.spine.Slot;
        }
        if (!slot) {
            cc.error('updatePartialSkin:', slotsName)
            return;
        }
        slot.color.a = 1;
        const attachment: sp.spine.RegionAttachment = slot.getAttachment() as sp.spine.RegionAttachment;
        if (tex2d == null) {
            cc.error('tex2d null:', slotsName)
            return;
        }
        if (!attachment) {
            cc.error('updatePartialSkin attachment null:', slotsName)
            return;
        }
        if (CC_JSB) {
            console.log("huanzhuang-jsb")
            let regionInfo = this.makeRegionIno(tex2d);
            let spine = ani;
            if (!regionInfo) {
                return;
            }
            // @ts-ignore
            let jsbTex = new middleware.Texture2D();
            // const spineSkeletonData = cc.internal.SpineSkeletonData.prototype;
            // const textureIdx = spineSkeletonData.recordTexture(regionInfo.texture);
            jsbTex.setRealTextureIndex(0);
            jsbTex.setPixelsWide(regionInfo.origSize.width);
            jsbTex.setPixelsHigh(regionInfo.origSize.height);
            // jsbTex.setPixelsWide(regionInfo.rect.width);
            // jsbTex.setPixelsHigh(regionInfo.rect.height);
            jsbTex.setNativeTexture(regionInfo.texture.getImpl());

            if (spine) {
                let rt = {
                    x: 0, y: 0,
                    // x: regionInfo.rect.x, y: regionInfo.rect.y,
                    w: regionInfo.texture.width, h: regionInfo.texture.height
                };
                // @ts-ignore
                spine.updateRegion(slotsName, jsbTex, rt, regionInfo.degrees,
                    regionInfo.offset);
            }

        }
        else {
            console.log("huanzhuang-web")
            // let _tex2d = tex2d.getTexture();

            // // // @ts-ignore
            // // const skeTexture = new sp.SkeletonTexture({ width: _tex2d.width, height: _tex2d.height } as ImageBitmap);
            // // if (_tex2d) {
            // //     skeTexture.setRealTexture(_tex2d);
            // // }

            // // 使用缓存代替新建对象（核心修改）
            // let skeTexture = _renwu.textureCache[tex2d.name];
            // if (!skeTexture) {
            //     // @ts-ignore
            //     skeTexture = new sp.SkeletonTexture({ width: _tex2d.width, height: _tex2d.height } as ImageBitmap);
            //     skeTexture.setRealTexture(_tex2d);
            //     _renwu.textureCache[tex2d.name] = skeTexture;
            // }

            // const region = new sp.spine.TextureAtlasRegion();
            // if (_tex2d) {
            //     region.width = _tex2d.width;
            //     region.height = _tex2d.height;
            //     region.originalWidth = _tex2d.width;
            //     region.originalHeight = _tex2d.height;
            // }

            // region.rotate = false;
            // region.u = 0;
            // region.v = 0;
            // region.u2 = 1;
            // region.v2 = 1;
            // region.texture = skeTexture;
            // region.renderObject = region;

            // attachment.region = region;
            // if (_tex2d) {
            //     attachment.width = _tex2d.width;
            //     attachment.height = _tex2d.height;
            // }

            // if (attachment instanceof sp.spine.MeshAttachment) {
            //     attachment.updateUVs();
            // } else {
            //     attachment.setRegion(region);
            //     attachment.updateOffset();
            // }

            // WEB平台处理逻辑
            let _tex2d = tex2d.getTexture();

            // 使用纹理缓存
            let skeTexture = _renwu.textureCache[tex2d.name];
            if (!skeTexture) {
                // @ts-ignore
                skeTexture = new sp.SkeletonTexture({
                    width: _tex2d.width,
                    height: _tex2d.height
                } as ImageBitmap);
                skeTexture.setRealTexture(_tex2d);
                _renwu.textureCache[tex2d.name] = skeTexture;
            }

            // 配置纹理区域
            const region = new sp.spine.TextureAtlasRegion();
            region.width = _tex2d.width;
            region.height = _tex2d.height;
            region.originalWidth = _tex2d.width;
            region.originalHeight = _tex2d.height;
            region.u = 0;
            region.v = 0;
            region.u2 = 1;
            region.v2 = 1;
            region.texture = skeTexture;
            region.renderObject = region;

            // 更新附件属性
            attachment.region = region;
            attachment.width = _tex2d.width;
            attachment.height = _tex2d.height;

            if (attachment instanceof sp.spine.MeshAttachment) {
                attachment.updateUVs();
            } else {
                attachment.setRegion(region);
                attachment.updateOffset();
            }
        }

    }

    copySkeletonData(renwu: DaoJuItem, spine: sp.Skeleton, data: sp.SkeletonData, is_set: boolean = true) {
        // 如果已有副本则不再创建
        if (renwu.skeletonCopy) {
            return;
        }
        let date = new Date();
        // 记录当前播放的动画
        const animation = spine.animation
        const spdata = data;
        let copy = new sp.SkeletonData();
        cc.js.mixin(copy, spdata);
        // @ts-ignore
        copy._uuid = spdata._uuid + "_" + date.getTime() + "_copy";
        let old = copy.name;
        let newName = copy.name + "_copy";
        copy.name = newName;
        copy.atlasText = copy.atlasText.replace(old, newName);
        // @ts-ignore
        copy.textureNames[0] = newName + ".png";
        // @ts-ignore
        copy.init && copy.init();

        if (is_set) {

            // 保存当前动画状态
            const trackEntry = spine.getCurrent(0);
            const currentTime = trackEntry ? trackEntry.trackTime : 0;

            spine.skeletonData = copy;

            // 恢复动画状态
            if (trackEntry) {
                spine.setAnimation(0, animation, trackEntry.loop);
                const newTrack = spine.getCurrent(0);
                newTrack.trackTime = currentTime;
            }
        }
    }

    // 新增颜色控制方法
    changeColorToSlot(slotName: string, color: cc.Color, skeleton: sp.Skeleton) {
        const slot = skeleton.findSlot(slotName);
        if (!slot) {
            cc.error(`找不到Slot: ${slotName}`);
            return;
        }

        if (CC_JSB) {

            // 原生平台使用直接属性赋值
            slot.color.r = color.getR() / 255;
            slot.color.g = color.getG() / 255;
            slot.color.b = color.getB() / 255;
            slot.color.a = color.getA() / 255;
        } else {
            const attachment: sp.spine.RegionAttachment = slot.getAttachment() as sp.spine.RegionAttachment;

            attachment.color = new sp.spine.Color(
                color.getR() / 255,
                color.getG() / 255,
                color.getB() / 255,
                color.getA() / 255
            );
        }
    }


}
