
import { _decorator, Component, Node, BoxCollider, BoxCollider2D, size, v2, PhysicsGroup, PhysicsSystem2D, EPhysics2DDrawFlags } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = test
 * DateTime = Fri May 13 2022 16:23:13 GMT+0800 (中国标准时间)
 * Author = linruimin
 * FileBasename = test.ts
 * FileBasenameNoExtension = test
 * URL = db://assets/test.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/zh/
 *
 */
 
@ccclass('test')
export class test extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    start () {
        // [3]
        PhysicsSystem2D.instance.enable = true;
        PhysicsSystem2D.instance.debugDrawFlags = EPhysics2DDrawFlags.Aabb |
        EPhysics2DDrawFlags.Pair |
        EPhysics2DDrawFlags.CenterOfMass |
        EPhysics2DDrawFlags.Joint |
        EPhysics2DDrawFlags.Shape;
    }

    onAdd()
    {
        const node:Node = new Node("collider_");
        node.setWorldPosition(0, 0, 0);
        node.setParent(this.node);
        
        const bc2 : BoxCollider2D = node.addComponent(BoxCollider2D);
        bc2.size = size(100, 100);
        bc2.offset = v2(50, 0);
        bc2.apply();
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/zh/scripting/decorator.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/zh/scripting/life-cycle-callbacks.html
 */
