const { ccclass, property } = cc._decorator;

import MD5 = require('./Video_md5.js');


@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Sprite)
    pic: cc.Sprite = null;

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    @property(cc.Button)
    button: cc.Button = null;

    start() {
        // init logic
        this.label.string = this.text;
        this.addEvent();
    }

    onDestroy() {
        this.removeEvent();
    }

    private addEvent() {
        this.button.node.on(cc.Node.EventType.TOUCH_END, this.onGetPic, this)
    }

    private removeEvent() {
        this.button.node.off(cc.Node.EventType.TOUCH_END, this.onGetPic, this)
    }



    private onGetPic() {
        let self = this;

        this.getImageBase64('/upload/o147-mili/20220328/1648483055.png').then((res: any) => {
            let img = new Image();
            img.src = res;
            img.onload = function () {
                let texture = new cc.Texture2D();
                texture.initWithElement(img);
                var frame = new cc.SpriteFrame(texture);
                self.pic.getComponent(cc.Sprite).spriteFrame = frame;
            }
        });

    }



    public async getImageBase64(imgUrl: string) {
        return new Promise((resolve, reject) => {
            var xhr = new XMLHttpRequest();
            xhr.open('get', 'https://51kcvod.llotu.com' + imgUrl, true);
            xhr.responseType = 'blob';
            xhr.onload = function () {
                if (this.status == 200) {
                    var blob = this.response.slice(8);
                    const reader = new FileReader();
                    reader.readAsDataURL(blob);
                    reader.onload = () => resolve(reader.result);
                    reader.onerror = (error) => reject(error);
                }
            };
            xhr.send();
        });

    }
}
