import ManagerBase from "../ManagerBase";
import Message, { MessageType } from "../Message";
import PlayerProperty from "../PlayerProperty";
import UIManager from "../UIManager";

const {ccclass, property} = cc._decorator;

@ccclass
export default class CoinControl extends ManagerBase {

    money:number = 0;

    start () {
        UIManager.Instance.RegisterReceiver(this);
    }

    ReceiveMessage(msg: Message): void {
        super.ReceiveMessage(msg);
        if(msg.Command == MessageType.UI_RefreshCoin){
            // //强转类型
            // let num = <number> msg.Content; 
            this.ChangeCoin(msg.Content);
            // console.log(msg.Content + "");
            
            
        }
    }

    ChangeCoin(value:number){
        PlayerProperty.Instance.playerMoneny += value;
        this.node.children[1].getComponent(cc.Label).string = PlayerProperty.Instance.playerMoneny + "";
    }
}
