import ComponentBase from "../ComponentBase";
import Message, { MessageType } from "../Message";
import ObjectManager from "./ObjectManager";

const {ccclass, property} = cc._decorator;

@ccclass
export default class FallingObject extends ComponentBase {

    @property(cc.Prefab)
    fallingCoin:cc.Prefab = null;

    NewObjectNum:number = 0;

    start(): void {
        //注册为Player消息的接受者
        ObjectManager.Instance.RegisterReceiver(this);
    }

    
    ReceiveMessage(msg:Message){
        super.ReceiveMessage(msg);

        let fallingObjectNum = Math.random();
        // 掉落普通物品
        if(msg.Command == MessageType.Falling_ObjectPos){
            if(fallingObjectNum < 0.4 ){
                this.NewObjectNum = 0;
                this.Falling(msg.Content);
            }else if(fallingObjectNum >= 0.4 && fallingObjectNum < 0.7){
                this.NewObjectNum = 1;
                this.Falling(msg.Content);
            }else if(fallingObjectNum >= 0.7 && fallingObjectNum < 0.9){
                this.NewObjectNum = 2;
                this.Falling(msg.Content);
            }else if(fallingObjectNum >= 0.9 && fallingObjectNum < 0.98){
                this.NewObjectNum = 3;
                this.Falling(msg.Content);
            }else if(fallingObjectNum >= 0.98 ){
                this.NewObjectNum = 4;
                this.Falling(msg.Content);
            }

        }
    }

    Falling(pos:cc.Vec2){
        switch(this.NewObjectNum){
            case 0:
                // console.log("没有掉落");
                break;
            case 1:
                this.RandomFalling(pos);
                // console.log("掉落1");
                break;
            case 2:
                this.RandomFalling(pos);
                this.RandomFalling(pos);
                // console.log("掉落2");
                break;
            case 3:
                this.RandomFalling(pos);
                this.RandomFalling(pos);
                this.RandomFalling(pos);
                // console.log("掉落3");
                break;
            case 4:
                this.RandomFalling(pos);
                this.RandomFalling(pos);
                this.RandomFalling(pos);
                this.RandomFalling(pos);
                // console.log("掉落4");
                break;
        }
    }

    // 随机掉落物品的方法
    RandomFalling(pos:cc.Vec2){
        let fallingObjectType = Math.random();
        if(fallingObjectType < 0.3 ){
            this.FallingCoin(pos);
        }else if(fallingObjectType >= 0.3 && fallingObjectType < 0.6){
        }else if(fallingObjectType >= 0.6 && fallingObjectType < 0.8){
        }else if(fallingObjectType >= 0.8 && fallingObjectType < 0.0){
        }else if(fallingObjectType >= 0.9 ){
        }

    }

    // 掉落金币的方法，此外还有随机掉落物品的方法
    FallingCoin(pos:cc.Vec2){
        let coin = cc.instantiate(this.fallingCoin);
        // 如果父节点为cc.director.getScene()的设置
        coin.setParent(cc.director.getScene());
        coin.setPosition(pos);
    }    

}
