import ComponentBase from "../ComponentBase";
import { MessageType } from "../Message";
import MessageCenter from "../MessageCenter";
import TagDescribe from "../TagDescribe";

const {ccclass, property} = cc._decorator;

@ccclass
export default class VaseEmpty extends ComponentBase {

    //箱子承受攻击的次数
    live:number = 1;

    start () {
        
    }

    onBeginContact(contact, self, other){
        if(other.tag == TagDescribe.Tag_PlayerBullet){
            this.live -= 1;
            if(this.live <= 0){
                let ObjectPos:cc.Vec2 = this.node.convertToWorldSpaceAR(cc.v2(-20,0));
                MessageCenter.SendCustomMessage(MessageType.Type_FallingObject,MessageType.Falling_ObjectPos, ObjectPos);
                this.node.runAction(cc.fadeOut(0.2));
                this.node.destroy();
            }
        }

    }
}
