import ComponentBase from "../ComponentBase";
import { MessageType } from "../Message";
import MessageCenter from "../MessageCenter";
import TagDescribe from "../TagDescribe";

const {ccclass, property} = cc._decorator;

@ccclass
export default class WoodBox extends ComponentBase {

    //箱子承受攻击的次数
    boxLive:number = 4;

    @property(cc.SpriteFrame)
    sprites:cc.SpriteFrame[] = [];

    start () {

    }

    onBeginContact(contact, self, other){
        if(other.tag == TagDescribe.Tag_PlayerBullet){
            this.boxLive -= 1;
            this.node.getComponent(cc.Sprite).spriteFrame = this.sprites[this.boxLive];
            if(this.boxLive <= 0){
                let ObjectPos:cc.Vec2 = this.node.convertToWorldSpaceAR(cc.v2(-20,0));
                MessageCenter.SendCustomMessage(MessageType.Type_FallingObject,MessageType.Falling_ObjectPos, ObjectPos);
                this.node.destroy();
            }
        }

    }

}
