import { _decorator, Component, find, Button, RigidBody, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Node_script')
export class Node_script extends Component {

    start() {
        this.ttBtn = find('Canvas/Button', this.node)
        this.ttBtn.getComponent(Button)
        this.ttBtn.on(Button.EventType.CLICK, this.testbtnClick, this);

        this.node.getComponentsInChildren(RigidBody).map((nodeRigid) => {
            nodeRigid.allowSleep = false
            nodeRigid.useCCD = true;
        })

        this.schedule(this.testbtnClick, 0.1, 1000, 1);
    }

    update(deltaTime: number) {
        
    }

    testbtnClick() {
        this.SphereGroup = find('SphereGroup', this.node)
        this.SphereGroup.children.map((child) => {
            this.randomMove(child);
        })
    }

    randomIntFromInterval(min, max) { // min and max included 
        return Math.floor(Math.random() * (max - min + 1) + min)
      }
  
    randomMove (node) {
        const randomBoolean =  Math.random() >= 0.5 ? 1 : -1
        const randX = this.randomIntFromInterval(20, 40) * randomBoolean
        const randZ = this.randomIntFromInterval(20, 40) * randomBoolean
        node.getComponent(RigidBody).applyImpulse(new Vec3(randX, 0, randZ))
    }
  

}

