import { _decorator, Node, VideoPlayer, Button, sys, Component } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('VideoPlayerTest')
export class VideoPlayerTest extends Component {
    @property(VideoPlayer)
    player:VideoPlayer;
    @property(Button)
    btn:Button;

    start() {
        // 点击按钮
        this.btn.node.on(Button.EventType.CLICK, ()=>{
            console.log(" btn clicked")
            this.player.node.active = true;
        })
        this.player.node.on(VideoPlayer.EventType.META_LOADED, ()=>{
            console.log(" player META_LOADED", this.player.isPlaying)
            if(!this.player.isPlaying){
                this.player.play();
            }
        })
        this.player.node.on(VideoPlayer.EventType.READY_TO_PLAY, ()=>{
            console.log(" player READY_TO_PLAY", this.player.isPlaying)
            if(!this.player.isPlaying){
                this.player.play();
            }
        })
        this.player.node.on(VideoPlayer.EventType.CLICKED, () => {
            console.log(" CLICKED", this.player.isPlaying)
            if(!this.player.isPlaying){
                this.player.play();
            }
        });
        this.player.node.on(VideoPlayer.EventType.NONE, ()=>{
            console.log(" player NONE")
        })
        this.player.node.on(VideoPlayer.EventType.PLAYING, ()=>{
            console.log(" player PLAYING")
        })
        this.player.node.on(VideoPlayer.EventType.PAUSED, ()=>{
            console.log(" player PAUSED")
        })
        this.player.node.on(VideoPlayer.EventType.STOPPED, ()=>{
            console.log(" player STOPPED")
        })
        this.player.node.on(VideoPlayer.EventType.COMPLETED, () => {
            console.log(" onVideoCompleted")
        });
        this.player.node.on(VideoPlayer.EventType.ERROR, (p)=>{
            console.error(" player ERROR", p)
        })
    }

}


