"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.onAfterBuild = exports.throwError = void 0;
const global_1 = require("./global");
const path_1 = require("path");
const fs_1 = require("fs");
exports.throwError = true;
const onAfterBuild = async function (options, result) {
    const { packages } = options;
    const { dest } = result;
    const packageOption = packages[global_1.PACKAGE_NAME];
    console.info('packageOption', packageOption);
    const dealSrcType = packageOption.hasOwnProperty('dealSrcType') && Number(packageOption.dealSrcType) || 0;
    console.log('dealSrcType', dealSrcType);
    if (dealSrcType > 0) {
        const bundleScriptsPath = (0, path_1.join)(dest, 'src', 'bundle-scripts');
        if (!(0, fs_1.existsSync)(bundleScriptsPath)) {
            return;
        }
        (0, fs_1.writeFileSync)((0, path_1.join)(bundleScriptsPath, 'game.js'), `console.log('__RemoteBundleScripts__分包加载成功')`, 'utf-8');
        const gameJsonPath = (0, path_1.join)(dest, 'game.json');
        const gameJson = JSON.parse((0, fs_1.readFileSync)(gameJsonPath, 'utf-8'));
        if (!gameJson.subpackages) {
            gameJson.subpackages = [];
        }
        gameJson.subpackages.push({
            name: '__ccRemoteBundleScripts__',
            root: 'src/bundle-scripts/'
        });
        (0, fs_1.writeFileSync)(gameJsonPath, JSON.stringify(gameJson, null, 0));
        if (dealSrcType == 1) {
            const gameJsPath = (0, path_1.join)(dest, 'game.js');
            let gameJsContent = (0, fs_1.readFileSync)(gameJsPath, 'utf-8');
            const idx = gameJsContent.indexOf('function onApplicationCreated');
            gameJsContent = gameJsContent.slice(0, idx) + `
function loadRemoteBundleScripts() {
    return new Promise((resolve, reject) => {
        const pf = globalThis.tt || globalThis.wx;
        if(pf.loadSubpackage) {
            pf.loadSubpackage({
                name: '__ccRemoteBundleScripts__',
                success: () => {
                    resolve();
                },
                fail: (err) => {
                    console.log('__RemoteBundleScripts__加载失败', err);
                }
            });
        } else {
            require('/src/bundle-scripts/game.js');
            resolve();
        }
        
    });
}
` + gameJsContent.slice(idx);
            gameJsContent = gameJsContent.replace('return onApplicationCreated(application);', `return loadRemoteBundleScripts().then(()=>{
            return onApplicationCreated(application);
        });`);
            (0, fs_1.writeFileSync)(gameJsPath, gameJsContent, 'utf-8');
        }
    }
};
exports.onAfterBuild = onAfterBuild;
