System.register(["./application.js"], function (_export, _context) {
  "use strict";

  var Application, canvas, $p, bcr, application;
  function setLoadingDisplay() {
    // Loading splash scene
    // var splash = document.getElementById('splash');
    // var progressBar = splash.querySelector('.progress-bar span');

    // splash.style.display = 'block';
    // progressBar.style.width = '0%';
    // cc.director.once(cc.Director.EVENT_AFTER_SCENE_LAUNCH, function () {
    //     splash.style.display = 'none';
    // });


    // 获取相关element
    let preload = document.getElementById('preload');
    // let left = document.getElementById('left');
    // let right = document.getElementById('right');

    // 加载首场景进度回调
    // onProgress = function (completedCount, totalCount, item) {
    //   if (totalCount == 1) {
    //     return;
    //   }
    //   // 计算百分比，设置进度
    //   let percent = 100 * completedCount / totalCount;
    //   let progress = percent * 3.6;
    //   if (progress <= 180) {
    //     right.style.transform = "rotate(" + progress + "deg)";
    //   } else {
    //     document.getElementById("con").style.display = "none";
    //     right.style.transform = "rotate(180deg)";
    //     left.style.transform = "rotate(" + (progress - 180) + "deg)";
    //   }
    // };

    // 监听一次首场景运行后触发的事件
    cc.director.once(cc.Director.EVENT_AFTER_SCENE_LAUNCH, function () {
      // splash.style.display = 'none';
      // 隐藏启动页div
      preload.style.display = 'none';
    });
  }
  function topLevelImport(url) {
    return System["import"](url);
  }

  return {
    setters: [function (_applicationJs) {
      Application = _applicationJs.Application;
    }],
    execute: function () {
      canvas = document.getElementById('GameCanvas');
      $p = canvas.parentElement;
      bcr = $p.getBoundingClientRect();
      canvas.width = bcr.width;
      canvas.height = bcr.height;
      application = new Application();
      topLevelImport('cc').then(function (engine) {
        setLoadingDisplay();
        return application.init(engine);
      }).then(function () {
        return application.start();
      })["catch"](function (err) {
        console.error(err);
      });
    }
  };
});