import { _decorator, Component, find, Node, NodeEventType, ScrollView, UITransform, Vec2, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('VDaluUi')
export class VDaluUi extends Component {
    svNode = null
    m_sv = null
    m_view = null
    m_ground = null
    bgNode = null
    button1 = null
    button2 = null
    max_scale = 1
    min_scale = 0.75
    m_scale = 1
    m_size = null
    onLoad() {
        this.svNode = find('Canvas/ground/VDalu/sv_map')
        this.m_view = find('Canvas/ground/VDalu/sv_map/view')
        this.m_ground = find('Canvas/ground/VDalu/sv_map/view/content')
        this.bgNode = find('Canvas/ground/VDalu/sv_map/view/content/background')
        this.button1 = find('Canvas/ui/VDaluUi/Button1')
        this.button2 = find('Canvas/ui/VDaluUi/Button2')
        this.m_sv = this.svNode.getComponent(ScrollView)
        this.m_size = this.m_ground.getComponent(UITransform).contentSize.clone()
        this.button1.on(Node.EventType.TOUCH_END, this.ScaleBg1, this)
        this.button2.on(Node.EventType.TOUCH_END, this.ScaleBg2, this)
        console.log('高宽', this.m_size.height, this.m_size.width)
        this.suofangBG()
    }

    ScaleBg1() {
        if (this.m_scale + 0.1 > this.max_scale) {
            this.m_scale = this.max_scale
        } else {
            this.m_scale += 0.1
        }
        this.svNode.setScale(this.m_scale, this.m_scale, 1)
        let width = this.m_size.width * this.m_scale
        let height = this.m_size.height * this.m_scale
        this.m_ground.getComponent(UITransform).setContentSize(width, height)
        // this.bgNode.getComponent(UITransform).setContentSize(width,height)  //设置就会有黑边
        console.log('执行放大,新的宽高', width, height)
    }

    ScaleBg2() {
        if (this.m_scale - 0.1 < this.min_scale) {
            this.m_scale = this.min_scale
        } else {
            this.m_scale -= 0.1
        }
        this.svNode.setScale(this.m_scale, this.m_scale, 1)
        let width = this.m_size.width * this.m_scale
        let height = this.m_size.height * this.m_scale
        this.m_ground.getComponent(UITransform).setContentSize(width, height)
        // this.bgNode.getComponent(UITransform).setContentSize(width,height)  //设置就会有黑边
        console.log('执行缩小,新的宽高', width, height)
    }

    suofangBG() {
        var touch0 = null, touch1 = null
        this.svNode.on(Node.EventType.TOUCH_MOVE, (e) => {
            // console.log('触碰')
            var touches = e.getTouches()
            if (touches.length >= 2) {
                touch0 = touch0 || touches[0].getLocation()
                touch1 = touch1 || touches[1].getLocation()
                this.m_sv.vertical = false
                this.m_sv.horizontal = false
                this.m_sv.stopAutoScroll()

                var point0 = touches[0].getLocation()
                var point1 = touches[1].getLocation()
                var wc = Vec2.distance(touch0, touch1) - Vec2.distance(point0, point1)
                if (wc > 0) {
                    if (this.m_scale >= this.min_scale) {
                        this.m_scale -= 0.01
                    }
                }
                else {
                    if (this.m_scale < this.max_scale) {
                        this.m_scale += 0.01
                    }
                }

                this.svNode.setScale(this.m_scale, this.m_scale, 1)

                var size = this.m_size
                var scale = this.m_scale
                this.m_ground.getComponent(UITransform).setContentSize(size.width * scale, size.height * scale)
                // this.bgNode.getComponent(UITransform).setContentSize(size.width * scale,size.height * scale)  //设置就会有黑边
                this.m_sv.vertical = true
                this.m_sv.horizontal = true
            }
            else {
                touch0 = null, touch1 = null
            }
        }, this)
    }


}


