import { _decorator, Button, Component, director, log, sp, SpriteFrame, Texture2D, Toggle } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Main')
export class Main extends Component {
    @property(sp.Skeleton) private spineA: sp.Skeleton = null;
    @property(sp.Skeleton) private spineB: sp.Skeleton = null;
    @property(SpriteFrame) private spfA: SpriteFrame = null;
    @property(SpriteFrame) private spfB: SpriteFrame = null;
    @property(Button) private btnA: Button = null;
    @property(Button) private btnB: Button = null;
    @property(Toggle) private toggleCreateNew: Toggle = null;
    @property(String) private slotName: string = '';
    @property(Button) private btnSwitchScene: Button = null;

    protected start(): void {
        this.btnA.node.on(Button.EventType.CLICK, this.onClick, this);
        this.btnB.node.on(Button.EventType.CLICK, this.onClick, this);
        this.btnSwitchScene.node.on(Button.EventType.CLICK, this.onSwitchClick, this);
    }

    protected onClick(btn: Button) {
        const createNew = this.toggleCreateNew.isChecked;
        log(`createNew: ${createNew}`);
        if (btn === this.btnA) {
            this.spineA.setSlotTexture(this.slotName, this.spfA.texture as Texture2D, createNew);
        } else {
            this.spineB.setSlotTexture(this.slotName, this.spfB.texture as Texture2D, createNew);
        }
    }

    protected onSwitchClick() {
        if (director.getScene().name === 'scene') {
            director.loadScene('scene2');
        } else {
            director.loadScene('scene');
        }
    }
}

