/**
 * @author ccbbs
 */

/* 1) Create an instance of CSInterface. */
const csInterface = new CSInterface();
bindEleEvent('create_btn', doCreate);
bindEleEvent('spawn_num_btn', doSpawnNum);
bindEleEvent('export_png', doExportPNG);
bindEleEvent('choose_directory_btn', doChooseDirectory);
document.querySelector('#cur_directory').innerHTML = getLocalStorage('cur_directory') || '';
const exWidth = document.getElementById('ex_width');
const exHeight = document.getElementById('ex_height');
const curLog = document.getElementById('log');
function bindEleEvent(id, cb, event = 'click') {
	const ele = document.querySelector('#' + id);
	ele.addEventListener(event, cb);
}
function doCreate() {
	const para = {
		exWidth: exWidth.value,
		exHeight: exHeight.value,
	};
	csInterface.evalScript('create(' + JSON.stringify(para) + ');', (activeLayersId) => {
		curLog.innerText = activeLayersId;
	});
}
function doSpawnNum() {
	csInterface.evalScript('spawnNum();', (str) => {
		curLog.innerText = str;
	});
}
function doExportPNG() {
	const cur_directory = getLocalStorage('cur_directory');
	if (!cur_directory) {
		alert('请先选择文件夹');
	} else {
    csInterface.evalScript('exportPNG("' + cur_directory + '");', (str) => {
		curLog.innerText = str;
	});
	}
}
const chooseDirectoryEle = document.querySelector('#choose_directory');
function doChooseDirectory() {
	try {
		var result = window.cep.fs.showOpenDialog(false, true, '标题', 'D:/', '');
		document.querySelector('#cur_directory').innerHTML = result.data;
		setLocalStorage('cur_directory', result.data);
	} catch (error) {
		alert(error);
	}
}
function setLocalStorage(key, value) {
	window.localStorage.setItem(key, value);
}
function getLocalStorage(key) {
	return window.localStorage.getItem(key);
}
