const { ccclass, property } = cc._decorator;

@ccclass
export default class Test3DCamera extends cc.Component {
    private _nodeList: cc.Node[] = [];

    onLoad() {
        // 開啟3D物理引擎
        cc.director.getPhysics3DManager().enabled = true;
        cc.Canvas.instance.node.on(cc.Node.EventType.MOUSE_MOVE, this._onMove, this);
        this._nodeList = this.node.getChildByName('BoxLayer').children;
    }

    private _onMove(event: any) {
        let ray = cc.find('3D Stage/3D Camera').getComponent(cc.Camera).getRay(event.getLocation());
        // @ts-ignore
        if (ray) {
            const colliders = cc.director.getPhysics3DManager().raycast(ray, 0, 5000, true);
            if (colliders) {
                colliders.forEach((element: any) => this._parseCastResult(element));
            }else{
                this._resetModelColor();
            }
        }
    }

    /**
     * 偵測結果判斷
     * @param item 物件
     * @returns
     */
    private _parseCastResult(item: any): void {
        const touchNode = item.collider.node;
        this._nodeList.forEach(node => {
            if (node.name == touchNode.name) {
                 this._changeModelColor(node, cc.color(255, 120, 120, 255));
            }else{
                this._changeModelColor(node, cc.color(127, 127, 127, 255));
            }
        });
    }

    private _resetModelColor() {
        this._nodeList.forEach(node => {
            this._changeModelColor(node, cc.color(127, 127, 127, 255));
        });
    }

    private _changeModelColor(node: cc.Node, color: cc.Color): boolean {
        try {
            const material = node.getComponent(cc.RenderComponent);
            material.getMaterial(0).setProperty('diffuseColor', color);
            return true;
        } catch (error) {
            return false;
        }
    }
}
