/**
 * Created by guoyuhai on 2025/1/22 21:00
 * Note:
 */
export class GlobalErrorHandler {
    static init() {
        // 捕获同步错误
        window.onerror = (message, source, lineno, colno, error) => {
            console.error("同步错误:", {
                message,
                source,
                lineno,
                colno,
                error,
            });
            GlobalErrorHandler.outputCompleteError({
                type: '同步错误',
                message,
                source,
                lineno,
                colno,
                error
            });
        };
        console.log("GlobalErrorHandler init success")
        // // 捕获未处理的 Promise 错误
        // window.onunhandledrejection = (event: PromiseRejectionEvent) => {
        //     console.log("未处理的 Promise 错误:", event.reason);
        //     const message = event.reason.message
        //     const stack = event.reason.stack
        //     GlobalErrorHandler.outputCompleteError({
        //         type: '未处理的 Promise 错误',
        //         reason: {type:event.type,message,stack}
        //     });
        // };
        if ('onunhandledrejection' in window) {
            console.log("当前环境支持 onunhandledrejection 事件");
            // window.onunhandledrejection = (event: PromiseRejectionEvent) => {
            //     console.log("未处理的 Promise 错误:", event.reason);
            //     const message = event.reason.message;
            //     const stack = event.reason.stack;
            //     GlobalErrorHandler.outputCompleteError({
            //         type: '未处理的 Promise 错误',
            //         reason: { type: event.type, message, stack }
            //     });
            // };
            // 处理未捕获的Promise错误
            window.addEventListener('unhandledrejection', function(event) {
                    console.log("未处理的 Promise 错误:", event.reason);
                    const message = event.reason.message;
                    // const stack = event.reason.stack.replace(/\n/g, '<br>');
                    const stack = event.reason.stack;
                    const jsErrorStack = JSON.stringify(event.reason);
                    console.log("smile:🚀:GlobalErrorHandler m: l:54->", jsErrorStack);
                    GlobalErrorHandler.outputCompleteError({
                        type: '未处理的 Promise 错误',
                        reason: { type: event.type, message, stack }
                    });
                event.preventDefault(); // 阻止默认处理
            });
        } else {
            console.warn("当前环境不支持 onunhandledrejection 事件");
        }
        if (typeof process !== 'undefined') {
            console.log("当前环境支持 process.unhandledRejection 事件");
            process.on('unhandledRejection', (reason, promise) => {
                console.log("捕获未处理的 Promise 错误:", reason);
            });
            console.log("当前环境支持 unhandledRejection success")
        }else {
            console.warn("当前环境不支持 process.unhandledRejection 事件");
        }

        // if(cc.sys.isNative) {
        //     window.__errorHandler = function (errorMessage, file, line, message) {
        //         let exception = {};
        //         exception.errorMessage = errorMessage;
        //         exception.file = file;
        //         exception.line = line;
        //         exception.message = message;
        //         if (window.exception != JSON.stringify(exception)) {
        //             window.exception = JSON.stringify(exception);
        //             console.log("Native 错误:", exception);
        //             //TODO: 发送请求上报异常
        //         }
        //     };
        // }


        // 捕获已处理的 Promise 错误
        window.onrejectionhandled = (event: PromiseRejectionEvent) => {
            console.log("Promise 错误已被处理:", event.reason);
            const message = event.reason.message
            const stack = event.reason.stack
            GlobalErrorHandler.outputCompleteError({
                type: '已处理的 Promise 错误',
                reason: {type:event.type,message,stack}
            });
        };
        console.log("GlobalErrorHandler init success")
        if(typeof jsb !== 'undefined'){
            jsb && jsb.onError(function (location, message, stack) {
                console.log("jsb 错误:", location);
                console.log("jsb message:", message);
                console.log("jsb stack:", stack);

                // // 如果发现堆栈信息不完整，重新生成一个 Error 对象以获取更多信息
                // if (!stack || stack.indexOf(message) === -1) {
                //     let err = new Error(message);
                //     stack = err.stack;
                //     console.log("666666666666")
                // }
                // console.error("Location##:", location);
                // console.error("Message##:", message);
                // console.error("Stack##:", stack);
            });
        }

        // let consoleError = window.console.error;
        // window.console.error = function(location, message, stack) {
        //     if("unhandledRejectedPromise"===message)
        //     {
        //         console.log("unhandledRejectedPromise");
        //         console.log(location);
        //         console.log(message);
        //         console.log(stack);
        //
        //         // window["__resHandler"]({"location":location,"message":message,"stack":stack});
        //     }
        //     consoleError && consoleError.apply(window, arguments);
        // }
    }

    // 输出完整的错误信息（可以进一步扩展为上传至错误监控系统等操作）
    static outputCompleteError(errorDetails: { type: string; [key: string]: any }) {
        // 这里可以扩展为将错误发送到远程日志或监控系统
        console.log("\n完整的错误信息：", JSON.stringify(errorDetails, null, 2));
    }
}
