import { _decorator, Asset, CCString, Component, SpriteFrame } from "cc";

const { ccclass, property } = _decorator;

@ccclass( 'I18UrlInfo' )
class I18UrlInfo {
    @property(CCString)
    url:string = "";

    @property([CCString])
    arrType:Array<string> = [];
}

@ccclass('I18PreUrl')
export class I18PreUrl extends Component {
    
    @property({ type:[I18UrlInfo], visible: true })
    _infos :Array<I18UrlInfo> = [];

    static getAssetType( str ){
        switch( str ){
            case "cc.SpriteFrame":
            case "sprite-frame":
                return SpriteFrame;
            default:
                return Asset;
        }
    }

    getUrls(){
        const self = this;
        const arrUrl = [];
        for( const info of self._infos ){
            arrUrl.push( info.url );
        }
        return arrUrl;
    }

}