import { JsonAsset } from "cc";
import I18Const from "./I18Const";

export default class TxtMgr {

    static instance : TxtMgr = null;
    static getInstance(): TxtMgr{
        if( TxtMgr.instance == null ){
            TxtMgr.instance = new TxtMgr();
        }
        return TxtMgr.instance;
    }

    data: any = null;
    setData( data: JsonAsset ){
        this.data = data.json;
    }

    getTxt( key: string, ...params ) : string {
        const self = this;

        if( self.data == null ){
            let result = key;
            for( const str of params ){
                result += " " + str;
            }
            return result;
        }

        let txtData = null;
        if( key.indexOf( I18Const.EditorKeyStart ) != 0 ){
            txtData = self.data;
        }else{
            txtData = self.data[ I18Const.EditorKey ];
        }

        if( txtData == null || txtData[key] == null ){
            let result = key;
            for( const str of params ){
                result += " " + str;
            }
            return result;
        }

        let result = txtData[key].replace( '\'', "\"" );
        for( let i=0; i<params.length; ++i ){
            result = result.replace( `{${i+1}}`, params[i].toString() );
        }
        return result;
    }
}

export const txt = function( key: string, ...params ){
    return TxtMgr.getInstance().getTxt( key, ...params );
}