import { _decorator, CCClass, Component, Sprite, SpriteFrame } from "cc";
import I18Mgr from "./i18/I18Mgr";
import { EBundleName } from "./i18/I18LanguageHelper";
import I18SpriteTool from "./i18/I18SpriteTool";

const { ccclass, property } = _decorator;

@ccclass('main')
export default class main extends Component {

    @property(Sprite)
    imgHelp:Sprite = null;

    @property([SpriteFrame])
    frames:Array<SpriteFrame> = [];

    _frameIndex = -1;

    protected onLoad(): void {
        I18Mgr.getInstance().initDefaultLanguage();
    }

    onBtnCN(){
        I18Mgr.getInstance().changeBundle( EBundleName.CN );
    }

    onBtnEN(){
        I18Mgr.getInstance().changeBundle( EBundleName.EN );
    }

    onBtnChangeSpriteFrame(){
        const self = this;
        const idx = (++self._frameIndex) % self.frames.length;
        I18SpriteTool.changeI18SpriteFrame( self.imgHelp, self.frames[idx] );
    }

}