import { _decorator, Collider2D, Component, Contact2DType, EPhysics2DDrawFlags, instantiate, IPhysics2DContact, Node, PhysicsSystem2D, Prefab } from 'cc';
const { ccclass, property } = _decorator;

const gOtherCollider: Set<Collider2D> = new Set()
globalThis.gOtherCollider = gOtherCollider

@ccclass('Check')
export class Check extends Component {
    @property(Prefab)
    rock: Prefab = null
    @property(Node)
    rockParent: Node = null
    start() {
        // 注册单个碰撞体的回调函数
        let collider = this.getComponent(Collider2D);
        if (collider) {
            collider.on(Contact2DType.BEGIN_CONTACT, this.onBeginContact, this);
            collider.on(Contact2DType.END_CONTACT, this.onEndContact, this);
        }

        for (let index = 0; index < 20; index++) {
            const node = instantiate(this.rock)
            node.setParent(this.rockParent)
            node.y = Math.random() * 300
            node.x = Math.random() * 300
        }
    }
    onBeginContact(selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 只在两个碰撞体开始接触时被调用一次
        gOtherCollider.add(otherCollider)
        console.log('onBeginContact', selfCollider, otherCollider, contact);
    }
    onEndContact(selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 只在两个碰撞体结束接触时被调用一次
        gOtherCollider.delete(otherCollider)
        console.log('onEndContact', selfCollider, otherCollider, contact);
        console.log(gOtherCollider.size);
        
    }
    onPreSolve(selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 每次将要处理碰撞体接触逻辑时被调用
        console.log('onPreSolve', selfCollider, otherCollider, contact);
    }
    onPostSolve(selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 每次处理完碰撞体接触逻辑时被调用
        console.log('onPostSolve', selfCollider, otherCollider, contact);
    }
}

PhysicsSystem2D.instance.debugDrawFlags = EPhysics2DDrawFlags.Aabb |
    EPhysics2DDrawFlags.Pair |
    EPhysics2DDrawFlags.CenterOfMass |
    EPhysics2DDrawFlags.Joint |
    EPhysics2DDrawFlags.Shape;