import * as fs from 'fs';
import * as path from 'path';

export async function OnEventGenerate() {
    let projectPath = Editor.Project.path;
    let eventInterfacePath = `${projectPath}/assets/scripts/game/event/interface`;
    let generatePath = `${projectPath}/assets/scripts/game/event/generate`;

    // 删除生成目录下的所有文件
    if (fs.existsSync(generatePath)) {
        const files = fs.readdirSync(generatePath);
        for (const file of files) {
            if(file.endsWith('.ts')){
                const filePath = path.join(generatePath, file);
                await Editor.Message.request('asset-db', 'delete-asset', filePath);
            }
        }
    }

    let tsFiles = readDir(eventInterfacePath);

    for (let i = 0; i < tsFiles.length; i++) {
        let tsFile = tsFiles[i];
        let newFileContent = '';
        let content = fs.readFileSync(tsFile, 'utf-8');
        let contents = content.split('\n');

        // 保留原有的import语句
        for (let j = 0; j < contents.length; j++) {
            let item = contents[j];
            if (item.includes('import')) {
                newFileContent += item + '\n';
            }
        }

        // 添加Event导入
        newFileContent += 'import { RegisterEvent } from "db://assets/startup/framework/event/Event";\n';
        newFileContent += 'import { EventBase } from "db://assets/startup/framework/event/EventBase";\n';
        newFileContent += 'import { EventDecorator } from "db://assets/startup/framework/event/EventDecorator";\n\n';

        // 获取文件名（不含扩展名）
        let fileName = path.basename(tsFile, '.ts');
        let interfaceName = fileName.replace('I', '');
        
        // 生成事件名称类
        newFileContent += `export class ${interfaceName}_Name {\n`;
        
        // 收集所有方法名
        let methodNames: string[] = [];
        for (let j = 0; j < contents.length; j++) {
            let item = contents[j];
            if (item.includes('(') && item.includes(')')) {
                let methodMatch = item.match(/(\w+)\s*\((.*?)\)/);
                if (methodMatch) {
                    let methodName = methodMatch[1];
                    methodNames.push(methodName);
                    // 为每个方法生成事件名
                    newFileContent += `    public static readonly ${methodName} = RegisterEvent("${interfaceName}_${methodName}");\n`;
                }
            }
        }
        
        newFileContent += '}\n\n';

        // 生成事件类
        newFileContent += `@EventDecorator\n`;
        newFileContent += `export class ${interfaceName} extends EventBase {\n\n`;

        // 处理接口方法
        for (let j = 0; j < contents.length; j++) {
            let item = contents[j];
            if (item.includes('interface')) {
                continue;
            }
            if (item.includes('(') && item.includes(')')) {
                let methodMatch = item.match(/(\w+)\s*\((.*?)\)/);
                if (methodMatch) {
                    let methodName = methodMatch[1];
                    let params = methodMatch[2];
                    newFileContent += `    ${methodName}(${params}): void {\n`;
                    // 提取参数名列表
                    let paramNames = params.split(',').map(p => p.trim().split(':')[0].trim()).filter(p => p);
                    newFileContent += `        this.event.dispatch${paramNames.length}(${interfaceName}_Name.${methodName}${paramNames.length > 0 ? ', ' + paramNames.join(', ') : ''});\n`;
                    newFileContent += '    }\n\n';
                }
            }
        }

        newFileContent += '}\n';

        // 确保目标目录存在
        if (!fs.existsSync(generatePath)) {
            fs.mkdirSync(generatePath, { recursive: true });
        }

        // 写入新文件
        let newFilePath = path.join(generatePath, `${interfaceName}.ts`);
        await Editor.Message.request('asset-db', 'create-asset', newFilePath, newFileContent);
    }
}

function readDir(dirPath: string): string[] {
    let tsFiles: string[] = [];
    let files = fs.readdirSync(dirPath);

    files.forEach(file => {
        let fullPath = path.join(dirPath, file);
        let stat = fs.statSync(fullPath);
        if (stat.isDirectory()) {
            readDir(fullPath);
        } else if (file.endsWith('.ts')) {
            tsFiles.push(fullPath);
        }
    });
    return tsFiles;
}