import * as fs from "fs";
import * as path from "path";

export async function onResGenerate() {
    const projectPtah = Editor.Project.path;
    const scriptDirectory = projectPtah + "/assets/scripts";
    const bundleDirectory = projectPtah + "/assets/bundle";

    const codeDefinePath = projectPtah + "/assets/startup/CodeBundleDefine.ts";
    const resDefinePath = projectPtah + "/assets/scripts/game/resCata/ResCata.ts";

    //在scriptDirectory目录下，遍历顶层目录的meta文件，获取目录名
    const codeBundleList: string[] = [];
    const metaFiles = fs.readdirSync(scriptDirectory);
    for (const metaFile of metaFiles) {
        if (metaFile.endsWith(".meta")) {
            const metaName = metaFile.replace(".meta", "");
            const metaPath = scriptDirectory + "/" + metaName + ".meta";
            const metaContent = fs.readFileSync(metaPath, "utf-8");
            const metaJson = JSON.parse(metaContent);
            if (metaJson?.userData?.isBundle) {
                codeBundleList.push(metaName);
            }
        }
    }

    await Editor.Message.request('asset-db', 'delete-asset', codeDefinePath);

    const codeDefineContent = `
        /**
         * 资源包定义
         * 自动化生成，请勿手动修改
         */
        export const CodeBundleDefine: string[] = [
            ${codeBundleList.map(bundle => `"${bundle}"`).join(",")}
        ];
    `;

    await Editor.Message.request('asset-db', 'create-asset', codeDefinePath, codeDefineContent);

    let resDefineContent = `
/**
* 资源包定义
* 自动化生成，请勿手动修改
*/
    `;

    //在bundleDirectory目录下，遍历顶层目录的meta文件，获取目录名
    const bundleList: string[] = [];
    const bundleFiles = fs.readdirSync(bundleDirectory);
    for (const bundleFile of bundleFiles) {
        if (bundleFile.endsWith(".meta")) {
            const bundleName = bundleFile.replace(".meta", "");
            const bundlePath = bundleDirectory + "/" + bundleName + ".meta";
            const bundleContent = fs.readFileSync(bundlePath, "utf-8");
            const bundleJson = JSON.parse(bundleContent);
            if (bundleJson?.userData?.isBundle) {
                bundleList.push(bundleName);
                const firstChar = bundleName.charAt(0).toUpperCase();
                resDefineContent += `\nexport const ${firstChar + bundleName.slice(1) + "Bundle"} = "${bundleName}";\n`;
            }
        }
    }

    //递归遍历bundleDirectory目录下的所有文件，获取文件名，并添加到resDefineContent中
    for (const bundleName of bundleList) {
        const bundlePath = path.join(bundleDirectory, bundleName);
        const bundleClassName = bundleName.charAt(0).toUpperCase() + bundleName.slice(1) + "Cata";
        const cataContent = { cata: `\nexport class ${bundleClassName} {\n` };
        processBundleDirectory(bundlePath, bundleName, cataContent);
        resDefineContent += cataContent.cata + `}\n\n`;
    }

    await Editor.Message.request('asset-db', 'delete-asset', resDefinePath);
    await Editor.Message.request('asset-db', 'create-asset', resDefinePath, resDefineContent);
}

function processBundleDirectory(dirPath: string, bundleName: string, cataContent: { cata: string }) {
    const files = fs.readdirSync(dirPath);
    
    for (const file of files) {
        const fullPath = path.join(dirPath, file);
        const stat = fs.statSync(fullPath);
        
        if (stat.isDirectory()) {
            // 递归处理子目录
            processBundleDirectory(fullPath, bundleName, cataContent);
        } else if (file.endsWith('.meta')) {
            // 处理meta文件
            const metaPath = fullPath;
            const metaContent = fs.readFileSync(metaPath, 'utf-8');
            const metaJson = JSON.parse(metaContent);
            
            const resourcePath = path.relative(path.join(Editor.Project.path, 'assets/bundle', bundleName), fullPath)
                .replace(/\\/g, '/')
                .replace('.meta', '')
                .replace(/\.(prefab|jpg|png|jpeg)$/, ''); // 移除文件扩展名
            
            if (metaJson.importer === 'prefab') {
                // 处理prefab资源
                const varName = formatResourceName(resourcePath);
                cataContent.cata += `    public static readonly ${varName} = "${resourcePath}";\n`;
            } else if (metaJson.importer === 'image') {
                // 处理图片资源，添加spriteFrame后缀
                const varName = formatResourceName(resourcePath);
                cataContent.cata += `    public static readonly ${varName} = "${resourcePath}/spriteFrame";\n`;
            }
        }
    }
}

function formatResourceName(resourcePath: string): string {
    return resourcePath
        .replace(/[\/\\]/g, '_')
        .replace(/\./g, '_')
        .replace(/[^a-zA-Z0-9_]/g, '')
        .toLowerCase();
}







