// ==========================================
// 入口与初始化逻辑
// ==========================================

window.addEventListener('DOMContentLoaded', () => {
    // UI Init
    const mode = localStorage.getItem('spine_view_mode') || 'list'; 
    const list = document.getElementById('custom-file-list');
    const btn = document.getElementById('btn-view-mode');
    if (list && btn) {
        if (mode === 'grid') {
            list.classList.remove('view-list');
            list.classList.add('view-grid');
            btn.innerText = "▦";
        } else {
            list.classList.remove('view-grid');
            list.classList.add('view-list');
            btn.innerText = "≣";
        }
    }
    
    // 初始化拖动功能
    window.makeDraggable('effect-panel', 'effect-panel-header');
    // 初始化缩放功能
    window.makeResizable('effect-panel', 'effect-resize-handle');
});

// 监听搜索框回车
const searchInput = document.getElementById('spine-file-search');
if(searchInput) {
    searchInput.addEventListener('keydown', (e) => {
        if(e.key === 'Enter') {
            const visibleItem = document.querySelector('.file-item:not([style*="display: none"])');
            if(visibleItem) {
                visibleItem.click(); 
                visibleItem.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
                e.target.blur();
            }
        }
    });
}
