/*
    Photoshop 查找重名图层脚本 (升级版)
    功能：遍历当前文档查找重名图层，报告结果，并自动选中所有重名图层。
    作者：AI Assistant
*/

#target photoshop
app.bringToFront();

function main() {
    // 1. 检查是否有文档打开
    if (app.documents.length == 0) {
        alert("请先打开一个 Photoshop 文档！");
        return;
    }

    var doc = app.activeDocument;
    var layersByName = {}; // 字典：{ "图层名": [图层对象1, 图层对象2], ... }
    var duplicatesInfo = []; // 存储重名信息用于弹窗
    var layersToSelect = []; // 最终要选中的图层对象列表

    // 2. 递归遍历所有图层并收集信息
    function traverseLayers(parent) {
        for (var i = 0; i < parent.layers.length; i++) {
            var layer = parent.layers[i];
            var layerName = layer.name;

            // 初始化数组
            if (!layersByName[layerName]) {
                layersByName[layerName] = [];
            }
            
            // 存入图层对象
            layersByName[layerName].push(layer);

            // 如果是图层组，递归进入
            if (layer.typename == "LayerSet") {
                traverseLayers(layer);
            }
        }
    }

    // 执行遍历
    traverseLayers(doc);

    // 3. 筛选出重名的图层
    for (var name in layersByName) {
        if (layersByName.hasOwnProperty(name)) {
            var list = layersByName[name];
            if (list.length > 1) {
                // 这是一个重名名字
                duplicatesInfo.push("【" + name + "】 x " + list.length);
                // 把该名字下的所有图层加入待选中列表
                for (var k = 0; k < list.length; k++) {
                    layersToSelect.push(list[k]);
                }
            }
        }
    }

    // 4. 处理结果
    if (layersToSelect.length > 0) {
        // 构建弹窗信息
        var message = "⚠️ 发现重名图层，点击【确定】将自动选中它们：\n\n";
        var limit = duplicatesInfo.length > 15 ? 15 : duplicatesInfo.length;
        for (var j = 0; j < limit; j++) {
            message += duplicatesInfo[j] + "\n";
        }
        if (duplicatesInfo.length > 15) {
            message += "... (以及其他 " + (duplicatesInfo.length - 15) + " 组)\n";
        }

        // 弹窗提示
        alert(message);

        // 5. 执行选中操作 (使用 ActionManager 以支持多选)
        selectLayers(layersToSelect);

    } else {
        alert("✅ 完美！文档中没有发现重名图层。");
    }
}

// 辅助函数：通过 ID 选中图层
function selectLayers(layerList) {
    if (layerList.length == 0) return;

    // 先取消所有选择（可选，视习惯而定，这里直接选中第一个会替换当前选择）
    // 选中第一个 (replace selection)
    selectSingleLayerById(layerList[0].id, false);

    // 将其余的添加到选择 (add to selection)
    for (var i = 1; i < layerList.length; i++) {
        try {
            selectSingleLayerById(layerList[i].id, true);
        } catch(e) {
            // 忽略某些特殊图层无法选中的错误
        }
    }
}

// 核心：调用 Photoshop 内部命令选中指定 ID 的图层
function selectSingleLayerById(id, add) {
    var desc = new ActionDescriptor();
    var ref = new ActionReference();
    ref.putIdentifier(charIDToTypeID('Lyr '), id);
    desc.putReference(charIDToTypeID('null'), ref);
    
    // selectionModifier: addToSelection (加选) 或 replaceSelection (换选)
    var selectionMode = add ? stringIDToTypeID("addToSelection") : stringIDToTypeID("select");
    desc.putEnumerated(stringIDToTypeID('selectionModifier'), stringIDToTypeID('selectionModifierType'), selectionMode);
    
    // false = 不要把组作为整体选中（而是选组本身），通常保持 false
    desc.putBoolean(charIDToTypeID('MkVs'), false); 
    
    executeAction(charIDToTypeID('slct'), desc, DialogModes.NO);
}

// 运行主函数
main();

