import { _decorator, Component, Node, Camera, SpriteFrame, Sprite, ImageAsset, Texture2D, RenderTexture, View, view } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('test')
export class test extends Component {
    // 离屏部分
    @property({ type: Camera })
    offCamera: Camera = null;
    @property({ type: Sprite })
    offSprite: Sprite = null;
    offSpriteFrame: SpriteFrame = null;
    // 图片资源
    @property({ type: ImageAsset })
    imageAsset: ImageAsset = null;
    // rendertex的显示
    @property({ type: Sprite })
    testSprite: Sprite = null;
    testSpriteFrame: SpriteFrame = null;
    start() {
        this.offSpriteFrame = new SpriteFrame();
        this.testSpriteFrame = new SpriteFrame();
    }

    update(deltaTime: number) {

    }
    testClick() {
        const test1 = new Texture2D();
        test1.image = this.imageAsset;
        this.offSpriteFrame.texture = test1;
        // 看显示，反了，手动调整下
        this.offSpriteFrame.flipUVY = true;
        this.offSprite.spriteFrame = this.offSpriteFrame;

        const testRenderTex = new RenderTexture();
        const { width, height } = view.getVisibleSize();
        testRenderTex.reset({
            width,
            height
        });
        this.offCamera.targetTexture = testRenderTex;

        this.testSpriteFrame.texture = testRenderTex;
        this.testSprite.spriteFrame = this.testSpriteFrame;
    }
}


