//拆分表，所有满足拆分情况

import { splitTable } from "./MJSplitTable";


/* 
--[Comment]
--按花色分类的计数排序
cards = {
	[card_type] = {
		cnt = total_num,
		[card_value1] = num1,
		...
		[card_value9] = num9,
	},
}
*/
function count_sort(cards: number[] = [], gui_flags: { [key: number]: boolean; } = {}) {
	let t_cards: { [key: number]: number[]; } = {};
	let c_cards: { [key: number]: number; } = {};

	let gui_num = 0;
	for (let v of cards) {
		if (!gui_flags[v]) {
			let cv = v % 10;
			let ct = Math.floor(v / 10) % 10;
			if (!t_cards[ct]) {
				t_cards[ct] = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]; //t_cards[0]表示t_cards[ct]总个数
			}
			t_cards[ct][cv] = t_cards[ct][cv] + 1;
			t_cards[ct][0] = t_cards[ct][0] + 1;
			if (!c_cards[v]) {
				c_cards[v] = 0;
			}
			c_cards[v] = c_cards[v] + 1;
		} else {
			gui_num = gui_num + 1;
		}
	}

	return { t_cards, c_cards, gui_num };
}

/* 
--[Comment]
--获得单花色数组的拆分表
-- 
*/
function split_group(t: number[], ct: number) {
	let t_split: string[] = [];
	let tmp = "";

	if (ct <= 2) {
		for (let i = 1; i <= 9; i++) {   //9张牌 
			if (t[i] && t[i] != 0) {
				tmp = tmp + t[i];
			} else {   //一个连续牌队结束，将拆分插入拆分表
				if (tmp.length > 0) {
					t_split.push(tmp);
				}
				tmp = "";
			}
		}
	} else {
		for (let i = 1; i <= 9; i++) {   //字牌,只能为刻子
			if (t[i] && t[i] != 0) {
				t_split.push(t[i].toString());
			}
		}
	}

	//最后一个拆分
	if (tmp.length > 0) {
		t_split.push(tmp);
	}

	return t_split;
}

/*
--[Comment]
--判断是否满足拆分
--
*/
function check_iscansplit(subcards: number[], ct: number) {
	let t_split = split_group(subcards, ct);
	for (let v of t_split) {
		if (!splitTable[Number(v)]) {
			return false;
		}
	}

	return true;
}

/*
--[Comment]
--获得将牌所在花色数组的索引
--
*/
function get_jiang_index(t_cards: any) {
	let mod = null;
	let t_jiang = null;
	for (let k in t_cards) {
		mod = t_cards[k][0] % 3;
		if (mod != 0 && mod != 2) {
			return null;
		} else if (mod == 2) {
			if (t_jiang != null) {
				return null;
			}
			t_jiang = k;
		}
	}

	return t_jiang;
}

/*
--[Comment]
--获得将数组
--
*/
function get_jiang_table(t_cards: any, key: number, is_258jiang: boolean = false) {
	if (t_cards == null || t_cards[key] == null) {
		return [];
	}

	//--258将，将只能为序数牌
	if (is_258jiang && key > 2) {
		return [];
	}

	let jiang_table: number[] = [];
	let flags = { [2]: true, [5]: true, [8]: true };
	for (let i = 1; i <= 9; i++) {
		if (t_cards[key][i] && t_cards[key][i] >= 2) {
			if (is_258jiang) {
				if (flags[i]) {
					jiang_table.push(i);
				}
			} else {
				jiang_table.push(i);
			}
		}
	}

	return jiang_table;
}

/*
--[Comment]
-- 判断胡牌
-- t_cards：牌数组，格式t_cards[t][v],每个元素保存t类型值为v的牌的张数
--
*/
function can_hupai(t_cards: any, t_jiang: number, rule_list: { [key: string]: boolean; } = {}) {
	//--获得将数组
	let jiang_table = get_jiang_table(t_cards, t_jiang, rule_list.is_258jiang);
	let flag = false;

	//--尝试每一个将
	for (let v of jiang_table) {
		t_cards[t_jiang][v] = t_cards[t_jiang][v] - 2;
		flag = true;
		for (let ct in t_cards) {
			if (!check_iscansplit(t_cards[ct], Number(ct))) {
				flag = false;
				break;
			}
		}
		t_cards[t_jiang][v] = t_cards[t_jiang][v] + 2;
		if (flag) {
			return true;
		}
	}

	return false;
}

//----------------------------------------------------------------
//---------------------------------------------------------------

//--带赖子的胡牌

class M {

	/*
	--
	--转化牌格式
	--
	*/
	public static check_ishupai(t_cards: any, gui_num: number, rule_list: { [key: string]: boolean; } = {}) {
		//--只剩赖子，必能胡牌
		let is_empty: boolean = true;
		for (let k in t_cards) {
			is_empty = false;
			break;
		}
		if (is_empty) {
			return true;
		}

		let t: number[] = [0];
		for (let i = 1; i <= 45; i++) {
			t[i] = 0;
		}

		//--是否带字牌：31-34 风牌 41-43箭牌
		let is_withzi = false;
		if (t_cards[3] || t_cards[4]) {
			is_withzi = true;
		}

		for (let i in t_cards) {
			for (let j in t_cards[i]) {
				if (Number(j) > 0 && t_cards[i][j] != 0) {
					t[Number(i) * 10 + Number(j)] = t_cards[i][j];
				}
			}
		}

		return M.is_hupai(t, gui_num, rule_list.is_258jiang, is_withzi);
	}

	/*
	--
	--cards = { [val] = cnt}
	--
	*/
	public static is_hupai(cards: number[], gui_num: number, is_258jiang: boolean = false, is_withzi: boolean = false) {
		let eye_tbl: number[] = [];
		let empty = -1;

		//--for循环选出将牌
		let ct_wan = 2; //--0筒 1条 2万
		let flags = { [2]: true, [5]: true, [8]: true };
		for (let i = 1; i < cards.length; i++) {
			if (empty == -1 && cards[i] == 0) {   //--记录第一个个数为0的牌的值
				empty = i;
			}

			if (cards[i] > 0 && (cards[i] + gui_num >= 2)) {
				if (is_258jiang) {
					let ct = Math.floor(i / 10);
					let cv = i % 10;
					if (ct <= ct_wan && flags[cv]) {
						eye_tbl.push(i);
					}
				} else {
					eye_tbl.push(i);
				}
			}
		}

		if (empty > 0) {
			eye_tbl.unshift(empty); //--在第一个位置前插入-1,表示鬼做将
		}

		let hu = false;
		let cache: number[] = [0, 0, 0, 0, 0];	//  0,1,2,3

		//-- 减去将牌 3 * n
		for (let eye of eye_tbl) {
			//--鬼牌做将
			if (eye == empty) {
				hu = M.foreach_eye(cards, gui_num - 2, gui_num, 1000, cache, is_withzi);
			} else {
				let cnt: number = cards[eye];
				let eye_color: number = Math.floor(eye / 10);
				if (cnt == 1) {
					cards[eye] = 0;
					hu = M.foreach_eye(cards, gui_num - 1, gui_num, eye_color, cache, is_withzi);
				} else {
					cards[eye] = cards[eye] - 2;
					hu = M.foreach_eye(cards, gui_num, gui_num, eye_color, cache, is_withzi);
				}
				cards[eye] = cnt;
			}
			if (hu) {
				break;
			}
		}

		return hu;
	}

	/*
	--
	--处理将之外的牌形成扑所需赖子数是否小于未使用赖子数
	--
	*/
	protected static foreach_eye(cards: number[], gui_num: number, max_gui: number, eye_color: number, cache: number[], is_withzi: boolean) {
		let left_gui = gui_num;
		for (let i = 0; i <= 2; i++) {	//筒条万
			let cache_index = -1;
			if (eye_color != i) {
				//-- 代表将的花色
				cache_index = i;
			}

			let need_gui = M.check_normal(cards, i * 10 + 1, i * 10 + 9, max_gui, cache_index, cache);
			if (cache_index >= 0) {
				cache[cache_index] = need_gui + 1;
			}
			left_gui = left_gui - need_gui;
			if (left_gui < 0) {
				return false;
			}
		}

		let cache_index = -1;
		if (eye_color != 3) {
			cache_index = 3;
		}

		//--字牌单独拆
		let need_gui = 0;
		if (is_withzi) {
			need_gui = M.check_zi(cards, max_gui, cache_index, cache);
			if (cache_index > 1) {
				cache[4] = need_gui + 1;
			}
		}

		return left_gui >= need_gui;
	}

	/*
	--
	--获得序数牌（万条筒）形成扑所需最少赖子数
	--
	*/
	protected static check_normal(cards: number[], from: number, to: number, max_gui: number, cache_index: number, cache: number[]) {
		if (cache_index >= 1) {
			let n = cache[cache_index];
			if (n > 0) {
				return n - 1;
			}
		}

		//--牌数组序列化成一串数字
		//--eg:12341
		let n = 0;
		for (let i = from; i <= to; i++) {
			n = n * 10 + cards[i];
		}

		if (n == 0) {
			return 0;
		}

		return M.next_split(n, 0, max_gui);
	}

	/*
	--
	--拆分
	--
	*/
	protected static next_split(n: number, need_gui: number, max_gui: number) {
		let c = 0;
		do {
			if (n == 0) {
				return need_gui;
			}

			while (n > 0) {
				c = n % 10;
				n = Math.floor(n / 10);
				if (c != 0) {
					break;
				}
			}

			//--1张或4张
			if (c == 1 || c == 4) {
				return M.one(n, need_gui, max_gui);
				//--2张
			} else if (c == 2) {
				return M.two(n, need_gui, max_gui);
			}
		} while (true);

		return need_gui;
	}

	/*
	--
	--当前牌数为1或4的情况（4-3=1，和1的处理一样）
	--
	*/
	protected static one(n: number, need_gui: number, max_gui: number) {
		let c1 = n % 10;   //--下一张
		let c2 = Math.floor((n % 100) / 10);   //--下两张

		//--10 40
		if (c1 == 0) {
			need_gui = need_gui + 1; //--至少需要1个，构成顺子
		} else {
			n = n - 1;   //--下张牌-1，构成顺子
		}

		//--1*0 
		if (c2 == 0) {
			need_gui = need_gui + 1;  //--再加一张鬼
		} else {
			n = n - 10;   //--下下张牌 - 1
		}

		if (n == 0) {
			return need_gui;
		}

		if (need_gui > max_gui) {
			return need_gui;
		}

		//--继续拆
		return M.next_split(n, need_gui, max_gui);
	}

	/*
	--
	--处理当前牌数为2的情况
	--c1 下张牌数量，c2：后面第2张牌数量，c3：后面第3张牌数量，c4：后面第4张牌的数量
	-- c = 2
	*/
	protected static two(n: number, need_gui: number, max_gui: number) {
		let c1 = n % 10;                           //--下1张
		let c2 = Math.floor((n % 100) / 10);       //--下2张
		let c3 = Math.floor((n % 1000) / 100);     //--下3张
		let c4 = Math.floor((n % 10000) / 1000);   //--下4张

		let choose_ke = true;	//是否拆刻子 false拆顺子

		//--20 全拆刻子
		if (c1 == 0) { //--全拆刻子

		} else if (c1 == 1) { //--21
			//-- 刻子
			if (c2 == 0 || c2 == 1) {

			} else if (c2 == 2) {
				if (c3 == 2) {
					if (c4 == 2) {
						choose_ke = false;
					}
				} else if (c3 == 3) {
					if (c4 != 2) {
						choose_ke = false;
					}
				} else {
					choose_ke = false;
				}
			} else if (c2 == 3) {
				if (c3 == 0 || c3 == 2 || c3 == 1 || c3 == 4) {
					choose_ke = false;
				}
			} else if (c2 == 4) {
				if (c3 == 2) {
					if (c4 == 2 || c4 == 3 || c4 == 4) {
						choose_ke = false;
					}
				} else if (c3 == 3) {
					choose_ke = false;
				}
			}
		} else if (c1 == 2) { //--22
			choose_ke = false;   //--不拆刻子，拆顺子
		} else if (c1 == 3) {    //--23
			if (c2 == 2) {     //--232
				if (c3 == 1 || c3 == 4) {  //--2321,2324
					choose_ke = false;
				} else if (c3 == 2) {
					if (c4 != 2) {
						choose_ke = false;
					}
				}
			}
			if (c2 == 3) { //--223   --拆顺子
				choose_ke = false;
			} else if (c2 == 4) {     	//--224
				if (c3 == 2) {     		//--2242,拆顺子
					choose_ke = false;
				}
			}
		} else if (c1 == 4) { //--24
			if (c2 == 2 && c3 != 2) { //--242
				choose_ke = false;
			} else if (c2 == 3) {
				if (c3 == 0 || c3 == 1 || c3 == 2) {
					choose_ke = false;
				}
			} else if (c2 == 4) {
				if (c3 == 2) {
					choose_ke = false;
				}
			}
		}

		if (choose_ke) {
			need_gui = need_gui + 1;
		} else {
			if (c1 < 2) {
				need_gui = need_gui + (2 - c1);
				n = n - c1;
			} else {
				n = n - 2;
			}

			if (c2 < 2) {
				need_gui = need_gui + (2 - c2);
				n = n - c2;
			} else {
				n = n - 20;
			}
		}

		if (n == 0) {
			return need_gui;
		}

		if (need_gui > max_gui) {
			return need_gui;
		}

		return M.next_split(n, need_gui, max_gui);
	}

	/*
	--
	--处理字牌（东西南北中白发）
	--
	*/
	protected static check_zi(cards, max_gui, cache_index, cache) {
		if (cache_index >= 1) {
			let n = cache[cache_index];
			if (n > 0) {
				return n - 1;
			}
		}

		let need_gui = 0;

		//--字牌只能凑成刻子
		for (let i = 31; i <= 45; i++) {
			let c = cards[i];
			if (c && c != 0) {
				if (c == 1 || c == 4) {    		//--1张或4张，需2个赖子
					need_gui = need_gui + 2;
				} else if (c == 2) {           //--2张，需1个赖子
					need_gui = need_gui + 1;
				}
				if (need_gui > max_gui) {
					return need_gui;
				}
			}
		}

		return need_gui;
	}

}

//---------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------
//------------外部接口

export class MJAlgoithmUtils {
	/*
	--[Comment]
	-- 基本胡牌规则：检验的牌满足n*ABC + m*DDD + EE（n,m<4,n+m<=4,ABCDE值可以相同)
	-- 即：玩家有总共4副三张(刻子或顺子) + 1对将牌（对子）
	-- 胡牌必须有一对将牌
	--
	*/
	public static is_hupai(t_cards: any, rule_list: { [key: string]: boolean; } = {}): boolean {
		let is_hu = false;
		let t_jiang = get_jiang_index(t_cards);
		if (t_jiang != null) {
			is_hu = can_hupai(t_cards, t_jiang, rule_list);
		}

		return is_hu;
	}

	/*
	--[Comment]
	--判断是否为七对（带赖子)
	--chu_card 其他玩家出的牌（打出的赖子牌不再算赖子）
	--
	*/
	public static check_is_qidui(hand_cards: number[], chu_card: number = null, gui_flags: { [key: number]: boolean; } = {}, is_7zhang: boolean = false): any {
		let count = 0;
		let is_da_7dui = 0;
		let max_num = is_7zhang ? 7 : 13;
		let duizi_num = is_7zhang ? 4 : 7;

		if ((chu_card && hand_cards.length == max_num) || (!chu_card && hand_cards.length == max_num + 1)) {
			let result = count_sort(hand_cards, gui_flags);
			let t_cards = result.t_cards;
			let gui_num = Number(result.gui_num);

			if (chu_card) {
				let cv = chu_card % 10;
				let ct = Math.floor(chu_card / 10) % 10;
				if (!t_cards[ct]) {
					t_cards[ct] = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
				}
				t_cards[ct][cv] = t_cards[ct][cv] + 1;
				t_cards[ct][0] = t_cards[ct][0] + 1;
			}

			for (let ct in t_cards) {
				for (let j in t_cards[ct]) {
					if (Number(j) > 0 && t_cards[ct][j] != 0) {
						let cnt = Number(t_cards[ct][j]);
						if (cnt == 2) {
							count = count + 1;
						} else if (cnt == 4) {
							count = count + 2;
							is_da_7dui = is_da_7dui + 1;
						} else if (cnt == 1) {
							gui_num = gui_num - 1;
							if (gui_num < 0) {
								return false;
							}
							count = count + 1;
						} else if (cnt == 3) {
							gui_num = gui_num - 1;
							if (gui_num < 0) {
								return false;
							}
							count = count + 2;
							is_da_7dui = is_da_7dui + 1;
						}
					}
				}
			}

			if (gui_num >= 0 && gui_num % 2 == 0) {
				count = count + Math.floor(gui_num / 2);
				if (Math.floor(gui_num / 2) > 0) {
					is_da_7dui = is_da_7dui + 1;
				}
				gui_num = gui_num % 2;
			}

			if (gui_num < 0 || gui_num % 2 != 0 || (count != duizi_num)) {
				return false;
			}

			return [true, (is_da_7dui == 1), (is_da_7dui > 1)];
		}

		return false;
	}

	/** 
	检测胡牌
	麻将牌格式：1-9筒1-筒9 11-19条1-条9 21-29万1-万9 31-34东南西北 41-43中发白（不含花牌）
	@param hand_cards 手牌（13/7张 + 1张摸牌） 格式：{牌值,牌值,牌值,....}
	@param chu_card 点炮胡，别家打出的牌。自摸胡该值为空
	@param rule_list 规则数组 {is_258jiang, is_needke,...} is_258jiang是否258做将 is_needke是否必带刻子
	@param gui_flags 鬼牌标记数组 格式: {[牌值] = true, [牌值] = true}
	*/
	public static IsHupai(hand_cards: number[], chu_card: number = null, rule_list: { [key: string]: boolean; } = {}, gui_flags: { [key: number]: boolean; } = {}): boolean {
		let result = count_sort(hand_cards, gui_flags);
		let t_cards = result.t_cards;
		let c_cards = result.c_cards;
		let gui_num = Number(result.gui_num);

		if (chu_card) {
			let cv = chu_card % 10;
			let ct = Math.floor(chu_card / 10) % 10;
			if (!t_cards[ct]) {
				t_cards[ct] = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
			}
			t_cards[ct][cv] = t_cards[ct][cv] + 1;
			t_cards[ct][0] = t_cards[ct][0] + 1;
			if (c_cards[chu_card]) {
				c_cards[chu_card] = c_cards[chu_card] + 1;
			} else {
				c_cards[chu_card] = 1;
			}
		}

		//必带刻子
		if (rule_list.is_needke) {
			for (let k in c_cards) {
				if (c_cards[k] + gui_num >= 3) {
					let cv = Number(k) % 10;
					let ct = Math.floor(Number(k) / 10) % 10;
					let cur_gui = gui_num;
					let is_hu = false;
					if (c_cards[k] >= 3) {
						t_cards[ct][cv] = t_cards[ct][cv] - 3;
						t_cards[ct][0] = t_cards[ct][0] - 3;
					} else {
						t_cards[ct][cv] = t_cards[ct][cv] - c_cards[k];
						t_cards[ct][0] = t_cards[ct][0] - c_cards[k];
						cur_gui = cur_gui - (3 - c_cards[k]);
					}

					//检测胡牌
					if (cur_gui > 0) {
						is_hu = M.check_ishupai(t_cards, cur_gui, rule_list);
					} else {
						is_hu = MJAlgoithmUtils.is_hupai(t_cards, rule_list);
					}

					//不能胡回滚数据
					if (!is_hu) {
						t_cards[ct][0] += (c_cards[k] - t_cards[ct][cv]);
						t_cards[ct][cv] = c_cards[k];
					} else {
						return true;
					}
				}
			}
			return false;
		}

		let is_hu = false;
		if (gui_num > 0) {
			is_hu = M.check_ishupai(t_cards, gui_num, rule_list);
		} else {
			is_hu = MJAlgoithmUtils.is_hupai(t_cards, rule_list);
		}

		//检测七对
		if (!is_hu && rule_list.is_7dui) {
			if (MJAlgoithmUtils.check_is_qidui(hand_cards, chu_card, gui_flags)) {
				return true;
			}
		}

		return is_hu;
	}
}

