
//胡牌类型
let huCardInfo = [
    { key: 0, text: "" },
    { key: 1, text: "花猪" },
    { key: 2, text: "没叫" },
    { key: 3, text: "有叫" },
    { key: 4, text: "自摸" },
    { key: 5, text: "平胡" },
    { key: 6, text: "五对请胡" },
    { key: 7, text: "对对胡" },
    { key: 8, text: "清一色" },
    { key: 9, text: "龙5对" },
    { key: 10, text: "清一色 + 对对胡" },
    { key: 11, text: "清5对" },
    { key: 12, text: "清龙5对" },
    { key: 13, text: "带幺九" },
    { key: 14, text: "将对" },
    { key: 15, text: "天胡" },
    { key: 16, text: "地胡" },
    { key: 17, text: "卡" },
    { key: 18, text: "勾（杠）" },
    { key: 19, text: "断幺九" },
    { key: 20, text: "杠上花" },
    { key: 21, text: "杠上炮" },
    { key: 22, text: "抢杠" },
    { key: 23, text: "海底炮" },
    { key: 24, text: "海底花" },
    { key: 25, text: "报胡" },
    { key: 26, text: "炮胡请胡" },
    { key: 27, text: "晒太阳" },
    { key: 28, text: "查大叫" },
    { key: 29, text: "没胡" },
    { key: 30, text: "硬报胡" },
    { key: 31, text: "软报胡" },

    { key: 40, text: "不断一卡" },
    { key: 41, text: "断卡" },
    { key: 42, text: "断卡勾" },
    { key: 43, text: "胡极品" },
    { key: 44, text: "硬卡" },
    { key: 45, text: "清带幺" },
    { key: 46, text: "断双卡" },
    { key: 47, text: "断3卡" },
    //血战麻将
    { key: 61, text: "小7对" },
    { key: 62, text: "龙七对" },
    { key: 63, text: "清7对" },
    { key: 64, text: "清龙7对" },
    { key: 65, text: "绝张" },
    { key: 66, text: "清幺九" },
    { key: 67, text: "转勾（杠）" },
    { key: 68, text: "门清" },
    { key: 69, text: "中张" },
    { key: 70, text: "金钩吊" },
    { key: 71, text: "将金钩钓(258)" },
    { key: 72, text: "清金钩钓" },
    { key: 73, text: "十八罗汉" },
    { key: 74, text: "清十八罗汉" },
    { key: 75, text: "将牌" },
    { key: 76, text: "将七对" },
    //"宜宾麻将
    { key: 77, text: "接本金" },
    { key: 78, text: "本金" },
    { key: 79, text: "金钩炮" },
    { key: 80, text: "没有万能牌" },
    { key: 81, text: "多个金钩钓加番" },

    //"贵阳麻将
    { key: 82, text: "地龙" },
    { key: 83, text: "清地龙" },
    { key: 84, text: "清龙背(清龙7对)" },
    { key: 85, text: "杀报" },
    { key: 86, text: "飘" },
    { key: 90, text: "认输" },
    //"辽宁麻将
    { key: 100, text: "坐庄" },
    { key: 101, text: "点炮" },
    { key: 102, text: "飘胡" },
    { key: 103, text: "加刚 / 挂挡" },
    { key: 104, text: "断门" },
    { key: 105, text: "鸡胡" },
    { key: 106, text: "穷胡" },
    { key: 107, text: "闭门" },
    { key: 108, text: "三家闭门" },
    { key: 109, text: "边卡夹" },
    { key: 110, text: "进宝胡" },
    { key: 111, text: "宝中宝" },
    { key: 112, text: "红中宝" },
    //济宁麻将
    { key: 120, text: "补上花" },
    { key: 121, text: "十三不靠" },
    //荆州晃晃
    { key: 130, text: "红中杠" },
    { key: 131, text: "赖子杠" },
    { key: 132, text: "明杠" },
    { key: 133, text: "续杠" },
    { key: 134, text: "暗杠" },
    { key: 135, text: "软自摸" },
    { key: 136, text: "硬自摸" },
    //红中癞子
    { key: 137, text: "四红中胡" },
    { key: 138, text: "抢杠胡" },
    { key: 139, text: "放杠胡" },
    //"黄州红中杠
    { key: 140, text: "海底捞" },
    { key: 141, text: "风一色" },
    { key: 142, text: "将一色" },
    { key: 143, text: "全求人" },
    { key: 144, text: "碰碰胡" },
    { key: 145, text: "皮子杠" },
    { key: 146, text: "对开口" },
    { key: 147, text: "大胡" },
    { key: 148, text: "硬胡" },
    { key: 149, text: "金顶" },
    { key: 150, text: "猪肚子" },
    { key: 151, text: "阳光顶" },
    //"襄阳卡五星
    { key: 160, text: "豪华七对" },
    { key: 161, text: "超豪华七对" },
    { key: 162, text: "超超豪华七对" },
    { key: 163, text: "卡五星" },
    { key: 164, text: "小三元" },
    { key: 165, text: "大三元" },
    { key: 166, text: "明四归" },
    { key: 167, text: "暗四归" },
    { key: 168, text: "大明四归" },
    { key: 169, text: "大暗四归" },
    { key: 170, text: "手抓一" },
    { key: 171, text: "海底炮" },
    { key: 172, text: "清一色碰碰胡" },
    { key: 173, text: "清一色七对" },
    { key: 174, text: "清一色手抓一" },
    { key: 175, text: "清一色豪华七对" },
    { key: 176, text: "清一色超豪华七对" },
    { key: 177, text: "清一色超超豪华七对" },
    { key: 178, text: "清一色卡五星" },
    { key: 179, text: "清一色明四归" },
    { key: 180, text: "清一色暗四归" },
    { key: 181, text: "包胡" },

    { key: 183, text: "三元" },
    { key: 184, text: "独听" },
    { key: 185, text: "花杠" },
    { key: 186, text: "五暗刻" },
    { key: 187, text: "四暗刻" },
    { key: 188, text: "三暗刻" },
    { key: 189, text: "门清一摸三" },
    { key: 190, text: "混一色" },
    { key: 191, text: "小四喜" },
    { key: 192, text: "大四喜" },
    { key: 193, text: "八仙过海" },
    { key: 194, text: "七抢一" },
    { key: 195, text: "人胡" },
    { key: 196, text: "风牌" },
    { key: 197, text: "花牌" },
    { key: 198, text: "庄家" },
    { key: 199, text: "连庄" },

    //马鞍山麻将
    { key: 129, text: "发财杠" },

    { key: 200, text: "小胡子" },
    { key: 201, text: "八支" },
    { key: 202, text: "双八支" },
    { key: 203, text: "大吊车" },
    { key: 204, text: "一条龙" },
    { key: 205, text: "六连" },
    { key: 206, text: "双六连" },
    { key: 207, text: "五通" },
    { key: 208, text: "双五通" },
    { key: 209, text: "四核" },
    { key: 210, text: "枯枝压(压绝)" },
    { key: 211, text: "不动手(门清)" },
    { key: 212, text: "压挡(边支、卡挡)" },
    { key: 213, text: "双扑" },
    { key: 214, text: "十老十小" },
    { key: 215, text: "全老全小" },

    { key: 216, text: "三张在手" },
    { key: 217, text: "三张碰出" },

]

/**
 * 麻将胡牌信息
 * 
 */
export default class MJHuTypeInfo {

    private static instance: MJHuTypeInfo;
    private huMaps: Map<number, string>;
    public static get Instance() {
        if (!MJHuTypeInfo.instance) {
            MJHuTypeInfo.instance = new MJHuTypeInfo();
            MJHuTypeInfo.instance.init();
        }
        return MJHuTypeInfo.instance;
    }

    private init() {
        this.huMaps = new Map<number, string>();
        for (let i = 0; i < huCardInfo.length; i++) {
            this.huMaps.set(huCardInfo[i].key, huCardInfo[i].text);
        }
    }


    /**
     * 获取胡牌信息
     * @param data 数据
     * @param spacer 间隔符 [] () {}  或者""  
     */
    public GetHuCardInfo(data, spacer: string = "[]", replaceCB?: (type: number) => string) {
        let infos: string[] = [];
        if (data.fan_types) {
            for (let i = 0; i < data.fan_types.length; i++) {
                let fan = data.fan_types[i].fan_type;
                if (replaceCB && replaceCB(fan) != "") {
                    let replace = replaceCB(fan);
                    if (spacer.length == 2) {
                        infos.push(spacer[0] + replace + spacer[1])
                    } else {
                        infos.push(replace);
                    }
                } else if (this.huMaps.has(fan)) {
                    if (spacer.length == 2) {
                        infos.push(spacer[0] + this.huMaps.get(fan) + spacer[1])
                    } else {
                        infos.push(this.huMaps.get(fan));
                    }
                }
            }
        }

        return infos.join(" ");
    }


}