/**
 * 规则解析
 * 需要传入规则配置表 
 */

import GLDefine from "../../../../BaseFrameWork/Common/GLDefine";
import ConfigCentre from "../../../../BaseFrameWork/Config/ConfigCentre";
import GLGameStateMgr from "../../../../BaseFrameWork/Manager/GLGameStateMgr";
import MJRuleConfig from "../../CommonRes/RuleJson/MJRuleConfig";


export default class MJRuleParse {

    private static _instance: MJRuleParse;
    private ruleStrArr: string[] = [];
    private ruleValue: Map<string, number>;
    private ruleConfig: any;
    private gameName: string;
    private gameId: any;

    public static get Instance() {
        if (!MJRuleParse._instance) {
            MJRuleParse._instance = new MJRuleParse();
        }
        return MJRuleParse._instance;
    }

    /**
     * 
     * @param gameId  规则配置表
     * @param jsonObje gamecfg_client 对象
     * @param cb 特殊规则在这里面加
     */
    public Init(gameId: any, jsonObje: any, cb?: (ruleStr: string[]) => void) {
        this.gameId = gameId
        this.ruleStrArr = [];
        this.ruleValue = new Map<string, number>();
        cb && cb(this.ruleStrArr);
        this.codeRule(jsonObje);
    }

    public codeRule(jsonObje) {
        let code = jsonObje.code;
        let roomData = GLGameStateMgr.instance.getRoomDataModel();
        let gameCfg = JSON.parse(roomData.GameCfg);
        // let ruleBaseCfg = MJResMgr.instance.GetJson(MJResType.JSON_RuleBaseCfg).json;
        // this.ruleConfig = MJResMgr.instance.GetJson(MJResType.JSON_GameCfg).json[this.gameId];
        let ruleConfig = MJRuleConfig.Conifg.get(this.gameId);

        this.gameName = ConfigCentre.instance.getGameName(roomData.getGameID());
        let roomType = roomData.getRoomType;
        let enterLimit = {
            "table_enter_coin": { coin: jsonObje.table_enter_coin, desc: "入场" },
            "table_out_coin": { coin: jsonObje.table_out_coin, desc: "出场" },
            "table_ju_enter_coin": { coin: jsonObje.table_ju_enter_coin, desc: "单局入场" },
        }

        let indexArr = []
        if (roomType == GLDefine.ERoomType.GOLD) {
            indexArr = ["table_enter_coin", "table_out_coin"];
        } else {
            indexArr = ["table_enter_coin", "table_ju_enter_coin"]
        }

        for (let i = 0; i < indexArr.length; i++) {
            let value = enterLimit[indexArr[i]];
            if (value.coin) {
                this.ruleStrArr.push(`${value.desc}:${value.coin / GLDefine.ZoomOutRatio}`);
            }
        }

        let arrText = [
            { desc: "人", value: gameCfg.player_nums },
            // { desc: "局", value: gameCfg.js_nums },
            // { desc: "底分", value: Math.floor(gameCfg.base_cell / 100) }
        ];

        for (let i = 0; i < arrText.length; i++) {
            if (arrText[i].value) {
                this.ruleStrArr.push(arrText[i].value + arrText[i].desc);
            }
        }

        if (ruleConfig) {
            for (let i = 0; i < ruleConfig.length; i++) {
                let data = ruleConfig[i];
                if (data && (data.ServerCode & code) > 0) {
                    this.ruleValue.set(data.desc, data.ServerCode & code);
                    this.ruleStrArr.push(data.desc);
                }
            }
        }

        // for (let i = 0; i < this.ruleConfig.length; i++) {
        //     let index = this.ruleConfig[i].RuleId;
        //     let cfg = ruleBaseCfg[index];
        //     if (cfg.ServerCode > 0 && (cfg.ServerCode & code) > 0) {
        //         this.ruleValue.set(cfg.RuleName, cfg.ServerCode & code);
        //         this.ruleStrArr.push(cfg.RuleName);
        //     }
        // }

        this.ruleStrArr;
    }

    /**获取规则字符串*/
    public GetRuleStr() {
        return this.ruleStrArr.join("  ");
    }

    public GetGameName() {
        return this.gameName;
    }

    public GetGameRule() {
        return this.ruleStrArr.join("  ");
    }

    public GetRuleValue(ruleName: string) {
        if (this.ruleValue && this.ruleValue.has(ruleName)) {
            return this.ruleValue.get(ruleName);
        }
        return 0;
    }

}