import { MJAlgoithmUtils } from "./MJAlgoithmUtils";
import { MJCardType } from "./MJEnumDefine";

export interface tingCardInfo {
    /**听的牌就是打出去就能胡牌了 */
    tingCard: number,
    /**能胡的牌 */
    huCardList: number[],
    /**测试能胡的数组 */
    cardList: number[],
    hucardType: number,
}

/*
麻将听牌
 */
export default class MJTingCardMgr {
    private static instance: MJTingCardMgr;
    /**检测清一色 */
    public isCheckQinYiSe: boolean = false;
    /**检测碰碰胡*/
    public isChekPengpengHu: boolean = false;
    /**检测将一色 */
    public isCheckJiangYise: boolean = false;
    /**检测风一色 */
    public isCheckFengyiSe: boolean = false;

    /**碰碰胡258当将 */
    public isPengpeng258jiang: boolean = true;




    /**底牌过滤 */
    public DiCardFilterdFunc: (dicards: number[]) => boolean;

    public static get Instance() {
        if (MJTingCardMgr.instance == null) {
            MJTingCardMgr.instance = new MJTingCardMgr();
        }
        return MJTingCardMgr.instance;
    }

    /**
     * 获取听牌列表
     * @param handCard  手牌
     * @param diCards 底牌
     * @param librarys 牌库
     * @param laizi  癞子牌
     * @param ruleInfo 牌的规则
     */
    public getTingCardList(handCard: number[], diCards: number[][], librarys: number[], laizi: number[], ruleInfo: { [key: string]: boolean }): tingCardInfo[] {
        handCard.sort((a, b) => a - b);
        let tingList: tingCardInfo[] = []
        let setList = new Set();
        let allrounds: { [val: number]: boolean } = {};
        laizi.forEach(val => allrounds[val] = true);

        for (let i = 0; i < handCard.length; i++) {
            let huCardList = []
            if (setList.has(handCard[i]))
                continue;
            let hucardType = 0;
            setList.add(handCard[i]);
            let tempHandCard = handCard.slice();
            tempHandCard.splice(i, 1);
            let jiaoList = librarys.filter(num => {
                let checkCards = tempHandCard.concat(num);
                let ishu = MJAlgoithmUtils.IsHupai(checkCards, null, ruleInfo, allrounds);

                //检测碰碰胡
                if (this.isChekPengpengHu) {
                    let pengpenghu = this.checkPengPenghu(checkCards, diCards, allrounds, laizi);
                    if (pengpenghu) {
                        ishu = pengpenghu;
                        cc.log("检测碰碰胡")
                        hucardType = 1;
                    }
                }

                //检测清一色
                if (this.isCheckQinYiSe) {
                    let qinyise = this.checkQingYiSe(checkCards, diCards, allrounds, laizi)
                    if (qinyise) {
                        ishu = qinyise;
                        cc.log("检测清一色", checkCards, qinyise);
                        hucardType = 2;
                    }
                }
                //检测将一色
                if (this.isCheckJiangYise) {
                    let jiangyise = this.checkJiangYise(checkCards, diCards, laizi);
                    if (jiangyise) {
                        ishu = jiangyise;
                        hucardType = 3;
                        cc.log("检测将一色", checkCards);
                    }
                }

                //检测风一色;
                if (this.isCheckFengyiSe && ishu) {
                    let fengyise = this.checkFengYiSe(checkCards, diCards, allrounds, laizi);
                    if (fengyise) {
                        hucardType = 4;
                        ishu = fengyise;
                        cc.log("检测风一色", checkCards);
                    }
                }

                if (ishu) {
                    let testHuCards = checkCards.slice(0);
                    huCardList.push(testHuCards)
                }
                return ishu;
            });

            if (jiaoList.length > 0) {
                tingList.push({
                    tingCard: handCard[i],
                    huCardList: jiaoList,
                    cardList: huCardList,
                    hucardType: hucardType,
                })
            }
        }
        return tingList;
    }


    /**检测清一色*/
    private checkQingYiSe(handCards: number[], diCards: number[][], allrounds: { [val: number]: boolean }, laizi: number[]) {
        let arrs = []
        if (diCards) {
            for (let i = 0; i < diCards.length; i++) {
                //仰牌也算清一色
                if (diCards[i].length >= 3) {
                    if (this.DiCardFilterdFunc && this.DiCardFilterdFunc(diCards[i])) {
                        continue;
                    } else {
                        arrs = arrs.concat(diCards[i]);
                    }
                }
            }
            // arrs = diCards.reduce((a, b) => a.concat(b));
        }

        let tempHandCard = arrs.concat(handCards);
        let firstCode = Math.floor(tempHandCard[0] / 10);
        for (let i = 0; i < tempHandCard.length; i++) {
            if (Math.floor(tempHandCard[i] / 10) != firstCode) {
                if (laizi && laizi.length > 0 && laizi[0] == tempHandCard[i]) {
                    continue;
                }
                return false;
            }
        }

        let ruleInfo = {
            is_needke: false,
            /**258将 */
            is_258jiang: false,
            /**七对 */
            is_7dui: true
        }
        let ishu = MJAlgoithmUtils.IsHupai(handCards, null, ruleInfo, allrounds);
        return ishu;
    }

    public checkPengPenghu(handCards: number[], diCards: number[][], allrounds: { [val: number]: boolean }, laiziCards: number[]) {
        if (!this.isDicardPengpengHu(diCards)) return false;
        let huCards = handCards.slice(0)
        let laizinum = handCards.filter((a) => a == laiziCards[0]).length;
        let cardInfos = new Map<number, number>()
        let jangshu = 0;
        for (let index = 0; index < huCards.length; index++) {
            if (!cardInfos.has(huCards[index])) {
                cardInfos.set(huCards[index], 0);
            }
            let count = cardInfos.get(huCards[index]);
            cardInfos.set(huCards[index], ++count);
        }
        let ikeys = Array.from(cardInfos.keys());
        let jiangCard = 0;
        for (let index = 0; index < ikeys.length; index++) {
            if (ikeys[index] == laiziCards[0]) continue;
            let count = cardInfos.get(ikeys[index]);
            let num = ikeys[index] <= 29 ? ikeys[index] % 10 : 0;
            if (count == 1 || count == 4) {
                if (jangshu == 0) {
                    laizinum -= 1;
                    if (this.isPengpeng258jiang) {
                        if (num == 2 || num == 5 || num == 8) {
                            jangshu = 1;
                        }
                    } else {
                        jangshu = 1;
                    }
                } else {
                    laizinum -= 2;
                }
            } else if (count == 2) {
                if (jangshu == 0) {
                    if (this.isPengpeng258jiang) {
                        if (num == 2 || num == 5 || num == 8) {
                            jangshu = 1;
                        } else {
                            laizinum--;
                        }
                    } else {
                        jangshu = 1;
                    }
                } else {
                    laizinum--;
                }
            }
        }
        return laizinum >= 0 && jangshu == 1;
    }

    //碰碰胡
    private isDicardPengpengHu(diCards: number[][]) {
        if (!diCards) return true;
        for (let i = 0; i < diCards.length; i++) {
            if (diCards[i].length >= 3) {
                if (diCards[i][0] != diCards[i][1] && diCards[i][0] != diCards[i][2]) {
                    if (this.DiCardFilterdFunc && this.DiCardFilterdFunc(diCards[i])) {
                        continue;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    //检测将一色
    private checkJiangYise(handCards: number[], diCards: number[][], laizi: number[]) {
        let arrs = []
        if (diCards) {
            for (let i = 0; i < diCards.length; i++) {
                //仰牌也算清一色
                if (diCards[i].length >= 3) {
                    if (this.DiCardFilterdFunc && this.DiCardFilterdFunc(diCards[i])) {
                        continue;
                    } else {
                        arrs = arrs.concat(diCards[i]);
                    }
                }
            }
        }


        let cards = arrs.concat(handCards).filter((a) => {
            if (laizi) {
                if (a == laizi[0]) {
                    return false;
                }
            }

            let num = a % 10;
            if (a < MJCardType.DongFeng && (num == 2 || num == 5 || num == 8)) {
                return false;
            }
            return true;
        })
        return cards.length == 0;
    }

    checkFengYiSe(handCards: number[], diCards: number[][], allrounds: { [val: number]: boolean }, laizi: number[]) {
        let otherCards = []
        for (let i = 0; i < diCards.length; i++) {
            otherCards = diCards[i].filter(a => {
                if (a < MJCardType.DongFeng || a > MJCardType.Bai) {
                    return true;
                }
                return false;
            })
        }

        //底牌有其他牌，就不检测风牌了
        if (otherCards.length > 0) {
            return false;
        }

        let cards = handCards.filter(a => {
            if ((a < MJCardType.DongFeng || a > MJCardType.Bai)) {
                if (laizi) {
                    return a != laizi[0];
                }
                return true;
            }
            return false;
        })

        return cards.length == 0;
    }


    /**清理数据 */
    public Clear() {
        this.isCheckJiangYise = false;
        this.isCheckQinYiSe = false;
        this.isChekPengpengHu = false;
        this.isPengpeng258jiang = true;
        this.DiCardFilterdFunc = null;
    }



}