// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {
    @property(cc.Prefab)
    itemPre: cc.Prefab = null;

    protected onLoad(): void {}

    protected start(): void {
        this.schedule(
            () => {
                let newNode = new cc.Node();
                newNode.position = cc.v3(0, 0, 0);
                let newStreak = cc.instantiate(this.itemPre);
                newStreak.parent = newNode;
                newNode.parent = this.node;
                newNode.position = cc.v3(0, 0, 0);
                newNode.runAction(
                    cc.sequence(
                        cc.moveTo(0.5, cc.v2(400, 400)),
                        cc.callFunc(() => {
                            newNode.destroy();
                        })
                    )
                );
            },
            2,
            cc.macro.REPEAT_FOREVER
        );
    }
}
