class Listener {
    target: any = null;
    func: Function = null;
    priority = 0;
    bRemove = false;

    constructor(target, func, priority = 0) {
        this.target = target;
        this.func = func;
        this.priority = priority;
        this.bRemove = false;
    }

    onEvent(data) {
        if (this.bRemove == true) return;
        if (this.func == null) return;
        if (this.target == null) return;
        this.func.call(this.target, data);
    }

    onRemove() {
        this.bRemove = true;
    }
}

class LisenterGroup {
    eventName: string = "";
    listeners = [];
    arrAddListeners = [];
    bDispatch = false;
    eventDatas = [];

    constructor(eventName) {
        this.eventName = eventName;

        this.listeners = [];
        this.arrAddListeners = [];
        this.bDispatch = false;
        this.eventDatas = [];
    }

    isExist(listeners, target, func) {
        return this.getListener(listeners, target, func) != null;
    }

    addListener(target, func, priority = 0) {
        if (this.bDispatch == false) {
            if (this.isExist(this.listeners, target, func)) return;
            this.listeners.push(new Listener(target, func, priority));
            this.sortListener();
        } else {
            if (this.isExist(this.listeners, target, func)) return;
            if (this.isExist(this.arrAddListeners, target, func)) return;
            this.arrAddListeners.push(new Listener(target, func, priority));
        }
    }

    sortListener() {
        this.listeners.sort(function (a, b) {
            return b.priority - a.priority;
        });
    }

    getListener(listeners, target, func) {
        for (let listener of listeners) {
            if (listener.target != target) continue;
            if (listener.func != func) continue;
            if (listener.bRemove == true) continue;
            return listener;
        }
        return null;
    }

    removeListener(target, func = null) {
        if (func != null) {
            for (let i = 0; i < this.arrAddListeners.length; ) {
                let listener = this.arrAddListeners[i];
                if (listener.target == target && listener.func == func) {
                    this.arrAddListeners.splice(i, 1);
                } else {
                    ++i;
                }
            }

            for (let listener of this.listeners) {
                if (listener.target == target && listener.func == func) {
                    listener.onRemove();
                    return;
                }
            }
        } else {
            for (let i = 0; i < this.arrAddListeners.length; ) {
                let listener = this.arrAddListeners[i];
                if (listener.target == target) {
                    this.arrAddListeners.splice(i, 1);
                } else {
                    ++i;
                }
            }

            for (let listener of this.listeners) {
                if (listener.target == target) {
                    listener.onRemove();
                    return;
                }
            }
        }
    }

    empty() {
        return this.listeners.length <= 0;
    }

    clone(obj) {
        if (Object.prototype.toString.call(obj) == "[object Object]") {
            let newObj = {};
            for (let key in obj) {
                if (obj.hasOwnProperty(key)) {
                    newObj[key] = this.clone(obj[key]);
                }
            }
            return newObj;
        } else if (Object.prototype.toString.call(obj) == "[object Array]") {
            let newObj = [];
            for (let key in obj) {
                if (obj.hasOwnProperty(key)) {
                    newObj[key] = this.clone(obj[key]);
                }
            }
            return newObj;
        }
        return obj;
    }

    onEvent(data) {
        if (this.bDispatch) {
            this.eventDatas.push(this.clone(data));
            return;
        }

        this.bDispatch = true;
        this.discard();
        this.merge();

        for (let listener of this.listeners) {
            listener.onEvent(data);
        }

        this.bDispatch = false;

        if (this.eventDatas.length > 0) {
            let data2 = this.eventDatas[0];
            this.eventDatas.splice(0, 1);
            this.onEvent(data2);
        }
    }

    merge() {
        if (this.arrAddListeners.length <= 0) return;
        for (let listener of this.arrAddListeners) {
            this.listeners.push(listener);
        }
        this.sortListener();
        this.arrAddListeners.splice(0, this.arrAddListeners.length);
    }

    discard() {
        for (let i = 0; i < this.listeners.length; ) {
            if (this.listeners[i].bRemove) {
                this.listeners.splice(i, 1);
            } else {
                ++i;
            }
        }
    }
}

export default class EventManager {
    static g_instance = null;

    static share() {
        if (EventManager.g_instance == null)
            EventManager.g_instance = new EventManager();
        return EventManager.g_instance;
    }

    listenerGroup = [];
    constructor() {
        this.listenerGroup = [];
    }

    addListener(eventName, target, func) {
        let group = this.getListenerGroup(eventName);
        if (group == null) {
            group = new LisenterGroup(eventName);
            this.listenerGroup.push(group);
        }

        group.addListener(target, func);
    }

    removeListener(eventName, target, func) {
        for (let i = 0; i < this.listenerGroup.length; ++i) {
            let group = this.listenerGroup[i];
            if (group.eventName == eventName) {
                group.removeListener(target, func);

                if (group.empty()) {
                    this.listenerGroup.splice(i, 1);
                }
                return;
            }
        }
    }

    removeTarget(target) {
        for (let i = 0; i < this.listenerGroup.length; ) {
            let group = this.listenerGroup[i];
            group.removeListener(target);

            if (group.empty()) {
                this.listenerGroup.splice(i, 1);
            } else {
                ++i;
            }
        }
    }

    getListenerGroup(eventName) {
        for (let group of this.listenerGroup) {
            if (group.eventName == eventName) {
                return group;
            }
        }
        return null;
    }

    dispatchEvent(eventName, data?) {
        let group = this.getListenerGroup(eventName);
        if (group != null) {
            group.onEvent(data);
        }
    }
}

export let addEventListener = function (eventName, target, func) {
    EventManager.share().addListener(eventName, target, func);
};

/**
 * 移除监听器
 * @param eventName 事件名称 || target
 * @param target obj
 * @param func 处理函数
 * @example
 * removeEventListener( "event1", this, this.func1 );
 * removeEventListener( this );
 */
export let removeEventListener = function (eventName, target?, func?) {
    if (eventName == null) return;

    if (target != null) {
        EventManager.share().removeListener(eventName, target, func);
    } else {
        EventManager.share().removeTarget(eventName);
    }
};

export let dispatchEvent = function (eventName, data?) {
    EventManager.share().dispatchEvent(eventName, data);
};

/*
    example:
        cc.class({
            start(){
                addEventListener( "event1", this, this.func1 );
                addEventListener( "event2", this, this.func1, 1 );
            },

            testAdd(){
                addEventListener( "event1", this, this.func1 );
            },

            testRemove(){
                removeEventListener( "event1", this, this.func1 );
            },

            testDispatch(){
                dispatchEvent( "event1" );
                dispatchEvent( "event1", 1 );

                let obj = {};
                obj.key = 1;
                obj.key2 = 2;
                dispatchEvent( "event1", obj );

                dispatchEvent( "event1", [ 1, 2 ] );
            },

            func1(){
                //do some thing
            },

            onDestroy(){
                removeEventListener( this );
            },
        );
 */
